/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.stash;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.StashCreateOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;

public class StashCreateUI {
    private Repository repo;
    private Shell shell;

    public StashCreateUI(Shell shell, Repository repo) {
        this.shell = shell;
        this.repo = repo;
    }

    public boolean createStash() {
        InputDialog commitMessageDialog = new InputDialog(this.shell, UIText.StashCreateCommand_titleEnterCommitMessage, UIText.StashCreateCommand_messageEnterCommitMessage, null, null);
        if (commitMessageDialog.open() != 0) {
            return false;
        }
        String message = commitMessageDialog.getValue();
        if (message.length() == 0) {
            message = null;
        }
        final StashCreateOperation op = new StashCreateOperation(this.repo, message);
        Job job = new Job(UIText.StashCreateCommand_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("", 1);
                try {
                    op.execute(monitor);
                    RevCommit commit = op.getCommit();
                    if (commit == null) {
                        StashCreateUI.this.showNoChangesToStash();
                    }
                }
                catch (CoreException e) {
                    Activator.logError(UIText.StashCreateCommand_stashFailed, e);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.STASH.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setUser(true);
        job.setRule(op.getSchedulingRule());
        job.schedule();
        return true;
    }

    private void showNoChangesToStash() {
        this.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)StashCreateUI.this.shell, (String)UIText.StashCreateCommand_titleNoChanges, (String)UIText.StashCreateCommand_messageNoChanges);
            }
        });
    }
}

