/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.ui.PartInitException;

public class OpenInCommitViewerHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        if (repository != null) {
            RevWalk revWalk = new RevWalk(repository);
            for (Object selected : this.getSelection(this.getPage()).toList()) {
                try {
                    RevCommit selectedCommit = (RevCommit)selected;
                    RevCommit reparsedCommit = revWalk.parseCommit((AnyObjectId)selectedCommit.getId());
                    CommitEditor.open(new RepositoryCommit(repository, reparsedCommit));
                }
                catch (IOException e) {
                    Activator.showError("Error opening commit viewer", e);
                }
                catch (PartInitException e) {
                    Activator.showError("Error opening commit viewer", e);
                }
            }
        }
        return null;
    }
}

