/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.op.CreatePatchOperation;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.GitCreatePatchWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class LocationPage
extends WizardPage {
    private static final String PATH_KEY = "GitCreatePatchWizard.LocationPage.path";
    private static final String LOCATION_KEY = "GitCreatePatchWizard.LocationPage.location";
    private static final String LOCATION_VALUE_CLIPBOARD = "clipboard";
    private static final String LOCATION_VALUE_FILE_SYSTEM = "filesystem";
    private static final String LOCATION_VALUE_WORKSPACE = "workspace";
    private Button cpRadio;
    Button fsRadio;
    private Text fsPathText;
    private Button fsBrowseButton;
    private Button wsRadio;
    private Text wsPathText;
    private Button wsBrowseButton;
    private boolean wsBrowsed = false;
    private boolean pageValid;
    private IContainer wsSelectedContainer;

    protected LocationPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        this.initializeDialogUnits((Control)composite);
        String selectedOption = this.getDialogSettings().get(LOCATION_KEY);
        if (selectedOption == null) {
            selectedOption = LOCATION_VALUE_CLIPBOARD;
        }
        GridData gd = new GridData(32);
        gd.horizontalSpan = 3;
        this.cpRadio = new Button(composite, 16);
        this.cpRadio.setText(UIText.GitCreatePatchWizard_Clipboard);
        this.cpRadio.setLayoutData((Object)gd);
        this.cpRadio.setSelection(LOCATION_VALUE_CLIPBOARD.equals(selectedOption));
        boolean isFileSystemSelected = LOCATION_VALUE_FILE_SYSTEM.equals(selectedOption);
        this.fsRadio = new Button(composite, 16);
        this.fsRadio.setText(UIText.GitCreatePatchWizard_File);
        this.fsRadio.setSelection(isFileSystemSelected);
        this.fsPathText = new Text(composite, 2048);
        gd = new GridData(768);
        this.fsPathText.setLayoutData((Object)gd);
        this.fsPathText.setText(this.createFileName());
        this.fsPathText.setEnabled(isFileSystemSelected);
        this.fsBrowseButton = new Button(composite, 8);
        this.fsBrowseButton.setText(UIText.GitCreatePatchWizard_Browse);
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = this.fsBrowseButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        this.fsBrowseButton.setLayoutData((Object)data);
        this.fsBrowseButton.setEnabled(isFileSystemSelected);
        boolean isWorkspaceSelected = LOCATION_VALUE_WORKSPACE.equals(selectedOption);
        this.wsRadio = new Button(composite, 16);
        this.wsRadio.setText(UIText.GitCreatePatchWizard_Workspace);
        this.wsRadio.setSelection(isWorkspaceSelected);
        this.wsPathText = new Text(composite, 2048);
        this.wsPathText.setLayoutData((Object)gd);
        this.wsPathText.setEnabled(isWorkspaceSelected);
        this.wsBrowseButton = new Button(composite, 8);
        this.wsBrowseButton.setText(UIText.GitCreatePatchWizard_Browse);
        this.wsBrowseButton.setLayoutData((Object)data);
        this.wsBrowseButton.setEnabled(isWorkspaceSelected);
        this.cpRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    LocationPage.this.fsPathText.setEnabled(false);
                    LocationPage.this.fsBrowseButton.setEnabled(false);
                    LocationPage.this.wsPathText.setEnabled(false);
                    LocationPage.this.wsBrowseButton.setEnabled(false);
                    LocationPage.this.getDialogSettings().put(LocationPage.LOCATION_KEY, LocationPage.LOCATION_VALUE_CLIPBOARD);
                    LocationPage.this.validatePage();
                }
            }
        });
        this.fsRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    LocationPage.this.fsPathText.setEnabled(true);
                    LocationPage.this.fsBrowseButton.setEnabled(true);
                    LocationPage.this.wsPathText.setEnabled(false);
                    LocationPage.this.wsBrowseButton.setEnabled(false);
                    LocationPage.this.fsPathText.setFocus();
                    LocationPage.this.getDialogSettings().put(LocationPage.LOCATION_KEY, LocationPage.LOCATION_VALUE_FILE_SYSTEM);
                    LocationPage.this.validatePage();
                }
            }
        });
        this.fsPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LocationPage.this.validatePage()) {
                    IPath filePath = Path.fromOSString((String)LocationPage.this.fsPathText.getText()).removeLastSegments(1);
                    LocationPage.this.getDialogSettings().put(LocationPage.PATH_KEY, filePath.toPortableString());
                }
            }
        });
        this.fsBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(LocationPage.this.getShell(), 40960);
                if (LocationPage.this.pageValid) {
                    File file = new File(LocationPage.this.fsPathText.getText());
                    dialog.setFilterPath(file.getParent());
                    dialog.setFileName(file.getName());
                } else {
                    dialog.setFileName("");
                }
                dialog.setText("");
                String path = dialog.open();
                if (path != null) {
                    LocationPage.this.fsPathText.setText(new Path(path).toOSString());
                }
                LocationPage.this.validatePage();
            }
        });
        this.wsRadio.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    LocationPage.this.fsPathText.setEnabled(false);
                    LocationPage.this.fsBrowseButton.setEnabled(false);
                    LocationPage.this.wsPathText.setEnabled(true);
                    LocationPage.this.wsBrowseButton.setEnabled(true);
                    LocationPage.this.wsPathText.setFocus();
                    LocationPage.this.getDialogSettings().put(LocationPage.LOCATION_KEY, LocationPage.LOCATION_VALUE_WORKSPACE);
                    LocationPage.this.validatePage();
                }
            }
        });
        this.wsPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LocationPage.this.validatePage()) {
                    IPath filePath = Path.fromOSString((String)LocationPage.this.wsPathText.getText()).removeLastSegments(1);
                    LocationPage.this.getDialogSettings().put(LocationPage.PATH_KEY, filePath.toPortableString());
                }
            }
        });
        this.wsBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WorkspaceDialog dialog = new WorkspaceDialog(LocationPage.this.getShell());
                LocationPage.this.wsBrowsed = true;
                dialog.open();
                LocationPage.this.validatePage();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.validatePage();
    }

    private String createFileName() {
        String suggestedFileName = this.getCommit() != null ? CreatePatchOperation.suggestFileName((RevCommit)this.getCommit()) : this.getRepository().getWorkTree().getName().concat(".patch");
        String path = this.getDialogSettings().get(PATH_KEY);
        if (path != null) {
            return Path.fromPortableString((String)path).append(suggestedFileName).toOSString();
        }
        return new File(System.getProperty("user.dir", ""), suggestedFileName).getPath();
    }

    private RevCommit getCommit() {
        return ((GitCreatePatchWizard)this.getWizard()).getCommit();
    }

    private Repository getRepository() {
        return ((GitCreatePatchWizard)this.getWizard()).getRepository();
    }

    protected boolean validatePage() {
        if (this.wsRadio.getSelection()) {
            this.pageValid = this.validateWorkspaceLocation();
        } else if (this.fsRadio.getSelection()) {
            this.pageValid = this.validateFilesystemLocation();
        } else if (this.cpRadio.getSelection()) {
            this.pageValid = true;
        }
        if (this.pageValid) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.pageValid);
        return this.pageValid;
    }

    private boolean validateFilesystemLocation() {
        String pathString = this.fsPathText.getText().trim();
        if (pathString.length() == 0 || !new Path("").isValidPath(pathString)) {
            this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemError);
            return false;
        }
        File file = new File(pathString);
        if (!file.isAbsolute()) {
            this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemInvalidError);
            return false;
        }
        if (file.isDirectory()) {
            this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryError);
            return false;
        }
        if (pathString.endsWith("/") || pathString.endsWith("\\")) {
            this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryNotExistsError);
            return false;
        }
        File parent = file.getParentFile();
        if (!parent.exists() || !parent.isDirectory()) {
            this.setErrorMessage(UIText.GitCreatePatchWizard_FilesystemDirectoryNotExistsError);
            return false;
        }
        return true;
    }

    private boolean validateWorkspaceLocation() {
        if (this.wsPathText.getText().equals("")) {
            if (this.wsRadio.getSelection() && this.wsBrowsed) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchEnterValidFileName);
            } else {
                this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchSelectByBrowsing);
            }
            return false;
        }
        Path pathToWorkspaceFile = new Path(this.wsPathText.getText());
        IStatus status = ResourcesPlugin.getWorkspace().validatePath(this.wsPathText.getText(), 1);
        if (status.isOK()) {
            IPath containerPath = pathToWorkspaceFile.removeLastSegments(1);
            IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember(containerPath);
            if (container == null) {
                if (this.wsRadio.getSelection()) {
                    this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchSelectByBrowsing);
                }
                return false;
            }
            if (!container.isAccessible()) {
                if (this.wsRadio.getSelection()) {
                    this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchProjectClosed);
                }
                return false;
            }
            if (ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)pathToWorkspaceFile).exists()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchFolderExists);
                return false;
            }
        } else {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    public File getFile() {
        if (this.pageValid && this.fsRadio.getSelection()) {
            return new File(this.fsPathText.getText().trim());
        }
        if (this.pageValid && this.wsRadio.getSelection()) {
            String filename = this.wsPathText.getText().trim();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile((IPath)new Path(filename));
            return file.getLocation().toFile();
        }
        return null;
    }

    private class LocationPageContentProvider
    extends BaseWorkbenchContentProvider {
        boolean showClosedProjects = false;

        private LocationPageContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                if (this.showClosedProjects) {
                    return allProjects;
                }
                ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                Object[] objectArray = allProjects;
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object project = objectArray[n2];
                    if (project.isOpen()) {
                        accessibleProjects.add(project);
                    }
                    ++n2;
                }
                return accessibleProjects.toArray();
            }
            return super.getChildren(element);
        }
    }

    private class WorkspaceDialog
    extends TitleAreaDialog {
        protected TreeViewer wsTreeViewer;
        protected Text wsFilenameText;
        protected Image dlgTitleImage;
        private boolean modified;

        public WorkspaceDialog(Shell shell) {
            super(shell);
            this.modified = false;
        }

        protected Control createContents(Composite parent) {
            Control control = super.createContents(parent);
            this.setTitle(UIText.GitCreatePatchWizard_WorkspacePatchDialogTitle);
            this.setMessage(UIText.GitCreatePatchWizard_WorkspacePatchDialogDescription);
            this.dlgTitleImage = UIIcons.WIZBAN_CREATE_PATCH.createImage();
            this.setTitleImage(this.dlgTitleImage);
            return control;
        }

        protected Control createDialogArea(Composite parent) {
            Composite parentComposite = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setFont(parentComposite.getFont());
            this.getShell().setText(UIText.GitCreatePatchWizard_WorkspacePatchDialogSavePatch);
            this.wsTreeViewer = new TreeViewer(composite, 2048);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 550;
            gd.heightHint = 250;
            this.wsTreeViewer.getTree().setLayoutData((Object)gd);
            this.wsTreeViewer.setContentProvider((IContentProvider)new LocationPageContentProvider());
            this.wsTreeViewer.setComparator((ViewerComparator)new ResourceComparator(1));
            this.wsTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.wsTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            Path existingWorkspacePath = new Path(LocationPage.this.wsPathText.getText());
            IResource selectedResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)existingWorkspacePath);
            if (selectedResource != null) {
                this.wsTreeViewer.expandToLevel((Object)selectedResource, 0);
                this.wsTreeViewer.setSelection((ISelection)new StructuredSelection((Object)selectedResource));
            }
            Composite group = new Composite(composite, 0);
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            Label label = new Label(group, 0);
            label.setLayoutData((Object)new GridData());
            label.setText(UIText.GitCreatePatchWizard_WorkspacePatchDialogFileName);
            this.wsFilenameText = new Text(group, 2048);
            this.wsFilenameText.setLayoutData((Object)new GridData(4, 128, true, false));
            this.setupListeners();
            return parent;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button button = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                button.setEnabled(false);
            }
            return button;
        }

        private void validateDialog() {
            String fileName = this.wsFilenameText.getText();
            if (fileName.equals("")) {
                if (this.modified) {
                    this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchDialogEnterFileName);
                    this.getButton(0).setEnabled(false);
                    return;
                }
                this.setErrorMessage(null);
                this.getButton(0).setEnabled(false);
                return;
            }
            if (!ResourcesPlugin.getWorkspace().validateName(fileName, 1).isOK() && this.modified) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchEnterValidFileName);
                this.getButton(0).setEnabled(false);
                return;
            }
            if (this.getSelectedContainer() == null) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchDialogEnterValidLocation);
                this.getButton(0).setEnabled(false);
                return;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath fullPath = LocationPage.this.wsSelectedContainer.getFullPath().append(fileName);
            if (workspace.getRoot().getFolder(fullPath).exists()) {
                this.setErrorMessage(UIText.GitCreatePatchWizard_WorkspacePatchFolderExists);
                this.getButton(0).setEnabled(false);
                return;
            }
            this.setErrorMessage(null);
            this.getButton(0).setEnabled(true);
        }

        protected void okPressed() {
            IFile file = LocationPage.this.wsSelectedContainer.getFile((IPath)new Path(this.wsFilenameText.getText()));
            if (file != null) {
                LocationPage.this.wsPathText.setText(file.getFullPath().toString());
            }
            LocationPage.this.validatePage();
            super.okPressed();
        }

        private IContainer getSelectedContainer() {
            Object obj = ((IStructuredSelection)this.wsTreeViewer.getSelection()).getFirstElement();
            if (obj instanceof IContainer) {
                LocationPage.this.wsSelectedContainer = (IContainer)obj;
            } else if (obj instanceof IFile) {
                LocationPage.this.wsSelectedContainer = ((IFile)obj).getParent();
            }
            return LocationPage.this.wsSelectedContainer;
        }

        protected void cancelPressed() {
            LocationPage.this.validatePage();
            super.cancelPressed();
        }

        public boolean close() {
            if (this.dlgTitleImage != null) {
                this.dlgTitleImage.dispose();
            }
            return super.close();
        }

        void setupListeners() {
            this.wsTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection s = (IStructuredSelection)event.getSelection();
                    Object obj = s.getFirstElement();
                    if (obj instanceof IContainer) {
                        LocationPage.this.wsSelectedContainer = (IContainer)obj;
                    } else if (obj instanceof IFile) {
                        IFile tempFile = (IFile)obj;
                        LocationPage.this.wsSelectedContainer = tempFile.getParent();
                        WorkspaceDialog.this.wsFilenameText.setText(tempFile.getName());
                    }
                    WorkspaceDialog.this.validateDialog();
                }
            });
            this.wsTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection s = event.getSelection();
                    if (s instanceof IStructuredSelection) {
                        Object item = ((IStructuredSelection)s).getFirstElement();
                        if (WorkspaceDialog.this.wsTreeViewer.getExpandedState(item)) {
                            WorkspaceDialog.this.wsTreeViewer.collapseToLevel(item, 1);
                        } else {
                            WorkspaceDialog.this.wsTreeViewer.expandToLevel(item, 1);
                        }
                    }
                    WorkspaceDialog.this.validateDialog();
                }
            });
            this.wsFilenameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    WorkspaceDialog.this.modified = true;
                    WorkspaceDialog.this.validateDialog();
                }
            });
        }
    }
}

