/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.history.CommitFileDiffViewer;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;

public class FileDiffContentProvider
implements IStructuredContentProvider {
    private TreeWalk walk;
    private RevCommit commit;
    private FileDiff[] diff;

    public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.walk = ((CommitFileDiffViewer)newViewer).getTreeWalk();
            this.commit = (RevCommit)newInput;
        } else {
            this.walk = null;
            this.commit = null;
        }
        this.diff = null;
    }

    public Object[] getElements(Object inputElement) {
        if (this.diff == null && this.walk != null && this.commit != null) {
            try {
                this.diff = FileDiff.compute(this.walk, this.commit);
            }
            catch (IOException err) {
                Activator.handleError(NLS.bind((String)UIText.FileDiffContentProvider_errorGettingDifference, (Object)this.commit.getId()), err, false);
            }
        }
        return this.diff != null ? this.diff : new Object[]{};
    }

    public void dispose() {
    }
}

