/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.ui.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GitCreateGeneralProjectPage
extends WizardPage {
    private File myDirectory;
    private Text projectText;
    private Text directoryText;
    private IProject[] wsProjects;
    private boolean defaultLocation;

    public GitCreateGeneralProjectPage(String path) {
        super(GitCreateGeneralProjectPage.class.getName());
        this.myDirectory = new File(path);
        this.setPageComplete(false);
        this.setTitle(UIText.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(UIText.WizardProjectsImportPage_ImportProjectsDescription);
        IPath parent = new Path(path).removeLastSegments(1);
        this.defaultLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)parent);
    }

    public GitCreateGeneralProjectPage() {
        super(GitCreateGeneralProjectPage.class.getName());
        this.setPageComplete(false);
        this.setTitle(UIText.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(UIText.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void setPath(String path) {
        this.myDirectory = path != null ? new File(path) : null;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout(2, false));
        workArea.setLayoutData((Object)new GridData(1808));
        new Label(workArea, 0).setText(UIText.GitCreateGeneralProjectPage_ProjectNameLabel);
        this.projectText = new Text(workArea, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.projectText);
        if (this.defaultLocation) {
            this.projectText.setEnabled(false);
        } else {
            this.projectText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitCreateGeneralProjectPage.this.checkPage();
                }
            });
        }
        new Label(workArea, 0).setText(UIText.GitCreateGeneralProjectPage_DirLabel);
        this.directoryText = new Text(workArea, 2048);
        this.directoryText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.directoryText);
        Dialog.applyDialogFont((Control)workArea);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.projectText.setText(this.myDirectory.getName());
            this.directoryText.setText(this.myDirectory.getPath());
            this.checkPage();
        }
        super.setVisible(visible);
    }

    public String getProjectName() {
        return this.projectText.getText();
    }

    public boolean isDefaultLocation() {
        return this.defaultLocation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPage() {
        block9: {
            String projectName;
            block8: {
                block7: {
                    projectName = this.projectText.getText();
                    this.setErrorMessage(null);
                    try {
                        block14: {
                            block11: {
                                block13: {
                                    block12: {
                                        block10: {
                                            if (this.myDirectory.exists()) break block10;
                                            this.setErrorMessage(NLS.bind((String)UIText.GitCreateGeneralProjectPage_DirNotExistMessage, (Object)this.myDirectory.getPath()));
                                            break block11;
                                        }
                                        if (this.myDirectory.isDirectory()) break block12;
                                        this.setErrorMessage(NLS.bind((String)UIText.GitCreateGeneralProjectPage_FileNotDirMessage, (Object)this.myDirectory.getPath()));
                                        break block11;
                                    }
                                    if (this.myDirectory.list(new FilenameFilter(){

                                        public boolean accept(File dir, String name) {
                                            return name.equals(".project");
                                        }
                                    }).length <= 0) break block13;
                                    this.setErrorMessage(NLS.bind((String)UIText.GitCreateGeneralProjectPage_FileExistsInDirMessage, (Object)".project", (Object)this.myDirectory.getPath()));
                                    break block11;
                                }
                                if (projectName.length() != 0) break block14;
                                this.setErrorMessage(UIText.GitCreateGeneralProjectPage_EnterProjectNameMessage);
                            }
                            this.setPageComplete(this.getErrorMessage() == null);
                            return;
                        }
                        IStatus result = ResourcesPlugin.getWorkspace().validateName(projectName, 4);
                        if (result.isOK()) break block7;
                        this.setErrorMessage(result.getMessage());
                    }
                    catch (Throwable throwable) {
                        this.setPageComplete(this.getErrorMessage() == null);
                        throw throwable;
                    }
                    this.setPageComplete(this.getErrorMessage() == null);
                    return;
                }
                if (!this.isProjectInWorkspace(projectName)) break block8;
                this.setErrorMessage(NLS.bind((String)UIText.GitCreateGeneralProjectPage_PorjectAlreadyExistsMessage, (Object)projectName));
                this.setPageComplete(this.getErrorMessage() == null);
                return;
            }
            if (this.defaultLocation) break block9;
            IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IStatus locationResult = ResourcesPlugin.getWorkspace().validateProjectLocation(newProject, (IPath)new Path(this.myDirectory.getPath()));
            if (locationResult.isOK()) break block9;
            this.setErrorMessage(locationResult.getMessage());
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private IProject[] getProjectsInWorkspace() {
        if (this.wsProjects == null) {
            this.wsProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return this.wsProjects;
    }

    private boolean isProjectInWorkspace(String projectName) {
        if (projectName == null) {
            return false;
        }
        IProject[] workspaceProjects = this.getProjectsInWorkspace();
        int i = 0;
        while (i < workspaceProjects.length) {
            if (projectName.equals(workspaceProjects[i].getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

