/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareIndexWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ITypedElement base;
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        IResource[] resources = this.getSelectedResources(event);
        IFile baseFile = (IFile)resources[0];
        String gitPath = RepositoryMapping.getMapping((IResource)baseFile).getRepoRelativePath((IResource)baseFile);
        try {
            base = CompareUtils.getIndexTypedElement(baseFile);
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        ITypedElement next = CompareUtils.getHeadTypedElement(repository, gitPath);
        if (next == null) {
            return null;
        }
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
        IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        CompareUtils.openInCompare(workBenchPage, (CompareEditorInput)in);
        return null;
    }

    public boolean isEnabled() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IResource resource = (IResource)this.getAdapter(selection.getFirstElement(), IResource.class);
        if (resource == null || !(resource instanceof IFile)) {
            return false;
        }
        Repository repository = this.getRepository();
        if (repository == null) {
            return false;
        }
        return this.isStaged(repository, resource);
    }

    private Object getAdapter(Object adaptable, Class c) {
        IAdaptable a;
        Object adapter;
        if (c.isInstance(adaptable)) {
            return adaptable;
        }
        if (adaptable instanceof IAdaptable && c.isInstance(adapter = (a = (IAdaptable)adaptable).getAdapter(c))) {
            return adapter;
        }
        return null;
    }

    private boolean isStaged(Repository repository, IResource resource) {
        String resRelPath = RepositoryMapping.getMapping((IResource)resource).getRepoRelativePath(resource);
        if (resRelPath == null || resRelPath.length() == 0) {
            return false;
        }
        try {
            FileTreeIterator fileTreeIterator = new FileTreeIterator(repository);
            IndexDiff indexDiff = new IndexDiff(repository, "HEAD", (WorkingTreeIterator)fileTreeIterator);
            indexDiff.setFilter(PathFilterGroup.createFromStrings(Collections.singletonList(resRelPath)));
            indexDiff.diff();
            return indexDiff.getAdded().contains(resRelPath) || indexDiff.getChanged().contains(resRelPath) || indexDiff.getRemoved().contains(resRelPath);
        }
        catch (IOException e) {
            Activator.error(NLS.bind((String)UIText.GitHistoryPage_errorLookingUpPath, (Object)resource.getFullPath().toString()), e);
            return false;
        }
    }
}

