/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitOperation
implements IEGitOperation {
    Collection<String> commitFileList;
    private boolean commitWorkingDirChanges = false;
    private String author;
    private String committer;
    private String message;
    private boolean amending = false;
    private boolean commitAll = false;
    private Repository repo;
    Collection<String> notTracked;
    private boolean createChangeId;
    private boolean commitIndex;
    RevCommit commit = null;

    public CommitOperation(IFile[] filesToCommit, Collection<IFile> notTracked, String author, String committer, String message) throws CoreException {
        this.author = author;
        this.committer = committer;
        this.message = message;
        if (filesToCommit != null && filesToCommit.length > 0) {
            this.setRepository(filesToCommit[0]);
        }
        if (filesToCommit != null) {
            this.commitFileList = this.buildFileList(Arrays.asList(filesToCommit));
        }
        if (notTracked != null) {
            this.notTracked = this.buildFileList(notTracked);
        }
    }

    public CommitOperation(Repository repository, Collection<String> filesToCommit, Collection<String> notTracked, String author, String committer, String message) throws CoreException {
        this.repo = repository;
        this.author = author;
        this.committer = committer;
        this.message = message;
        if (filesToCommit != null) {
            this.commitFileList = new HashSet<String>(filesToCommit);
        }
        if (notTracked != null) {
            this.notTracked = new HashSet<String>(notTracked);
        }
    }

    public CommitOperation(Repository repository, String author, String committer, String message) throws CoreException {
        this.repo = repository;
        this.author = author;
        this.committer = committer;
        this.message = message;
        this.commitIndex = true;
    }

    private void setRepository(IFile file) throws CoreException {
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
        if (mapping == null) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitOperation_couldNotFindRepositoryMapping, (Object)file), null));
        }
        this.repo = mapping.getRepository();
    }

    public void setRepository(Repository repository) {
        this.repo = repository;
    }

    private Collection<String> buildFileList(Collection<IFile> files) throws CoreException {
        HashSet<String> result = new HashSet<String>();
        for (IFile file : files) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)file);
            if (mapping == null) {
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.CommitOperation_couldNotFindRepositoryMapping, (Object)file), null));
            }
            String repoRelativePath = mapping.getRepoRelativePath((IResource)file);
            result.add(repoRelativePath);
        }
        return result;
    }

    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        Object monitor = m == null ? new NullProgressMonitor() : m;
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor actMonitor) throws CoreException {
                Date commitDate = new Date();
                TimeZone timeZone = TimeZone.getDefault();
                PersonIdent authorIdent = RawParseUtils.parsePersonIdent((String)CommitOperation.this.author);
                PersonIdent committerIdent = RawParseUtils.parsePersonIdent((String)CommitOperation.this.committer);
                if (CommitOperation.this.commitAll) {
                    CommitOperation.this.commitAll(commitDate, timeZone, authorIdent, committerIdent);
                } else if (CommitOperation.this.amending || CommitOperation.this.commitFileList != null && CommitOperation.this.commitFileList.size() > 0 || CommitOperation.this.commitIndex) {
                    actMonitor.beginTask(CoreText.CommitOperation_PerformingCommit, 20);
                    actMonitor.setTaskName(CoreText.CommitOperation_PerformingCommit);
                    CommitOperation.this.addUntracked();
                    CommitOperation.this.commit();
                    actMonitor.worked(10);
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(action, monitor);
    }

    private void addUntracked() throws CoreException {
        if (this.notTracked == null || this.notTracked.size() == 0) {
            return;
        }
        AddCommand addCommand = new Git(this.repo).add();
        boolean fileAdded = false;
        for (String path : this.notTracked) {
            if (!this.commitFileList.contains(path)) continue;
            addCommand.addFilepattern(path);
            fileAdded = true;
        }
        if (fileAdded) {
            try {
                addCommand.call();
            }
            catch (Exception e) {
                throw new CoreException(Activator.error(e.getMessage(), e));
            }
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void commit() throws TeamException {
        Date commitDate = new Date();
        TimeZone timeZone = TimeZone.getDefault();
        PersonIdent authorIdent = RawParseUtils.parsePersonIdent((String)this.author);
        PersonIdent committerIdent = RawParseUtils.parsePersonIdent((String)this.committer);
        Git git = new Git(this.repo);
        try {
            CommitCommand commitCommand = git.commit();
            commitCommand.setAuthor(new PersonIdent(authorIdent, commitDate, timeZone)).setCommitter(new PersonIdent(committerIdent, commitDate, timeZone)).setAmend(this.amending).setMessage(this.message).setInsertChangeId(this.createChangeId);
            if (!this.commitIndex) {
                for (String path : this.commitFileList) {
                    commitCommand.setOnly(path);
                }
            }
            this.commit = commitCommand.call();
        }
        catch (Exception e) {
            throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
        }
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setCommitAll(boolean commitAll) {
        this.commitAll = commitAll;
    }

    public void setComputeChangeId(boolean createChangeId) {
        this.createChangeId = createChangeId;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    private void commitAll(Date commitDate, TimeZone timeZone, PersonIdent authorIdent, PersonIdent committerIdent) throws TeamException {
        Git git = new Git(this.repo);
        try {
            this.commit = git.commit().setAll(true).setAuthor(new PersonIdent(authorIdent, commitDate, timeZone)).setCommitter(new PersonIdent(committerIdent, commitDate, timeZone)).setMessage(this.message).setInsertChangeId(this.createChangeId).call();
        }
        catch (JGitInternalException e) {
            throw new TeamException(CoreText.MergeOperation_InternalError, (Throwable)e);
        }
        catch (GitAPIException e) {
            throw new TeamException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ boolean access$8(CommitOperation commitOperation) {
        return commitOperation.commitWorkingDirChanges;
    }
}

