/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.notifications.ui;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.forms.MessageControl;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public abstract class NotificationControl
extends MessageControl {
    private static final String NOTIFICATIONS_PREF_PAGE = "org.eclipse.mylyn.commons.notifications.preferencePages.Notifications";
    private ImageHyperlink configureLink;
    private String preferencesPageId;

    public NotificationControl(Composite parent) {
        super(parent);
        this.setPreferencesPageId(NOTIFICATIONS_PREF_PAGE);
    }

    public String getPreferencesPageId() {
        return this.preferencesPageId;
    }

    public void setPreferencesPageId(String preferencesPageId) {
        this.preferencesPageId = preferencesPageId;
    }

    protected void createLinkControls(Composite buttonsComp) {
        if (this.getPreferencesPageId() != null) {
            this.configureLink = new ImageHyperlink(buttonsComp, 0);
            this.configureLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CONFIGURE));
            this.configureLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    PreferenceDialog pd = PreferencesUtil.createPreferenceDialogOn((Shell)NotificationControl.this.getShell(), (String)NotificationControl.this.getPreferencesPageId(), (String[])new String[0], (Object)NotificationControl.this.getEventId());
                    if (pd != null) {
                        pd.open();
                    }
                }

                public void linkEntered(HyperlinkEvent e) {
                    NotificationControl.this.configureLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CONFIGURE_HOVER));
                }

                public void linkExited(HyperlinkEvent e) {
                    NotificationControl.this.configureLink.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.NOTIFICATION_CONFIGURE));
                }
            });
            this.configureLink.setVisible(this.getEventId() != null);
        }
        super.createLinkControls(buttonsComp);
    }

    protected void setEventId(String eventId) {
        super.setEventId(eventId);
        if (this.configureLink != null) {
            this.configureLink.setVisible(eventId != null);
        }
    }
}

