/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.cdt.internal.ui.text.SingleCharReader;

public abstract class SubstitutionTextReader
extends SingleCharReader {
    protected static final String LINE_DELIM = System.getProperty("line.separator", "\n");
    private Reader fReader;
    private boolean fWasWhiteSpace;
    private int fCharAfterWhiteSpace;
    private boolean fReadFromBuffer;
    private StringBuffer fBuffer;
    private int fIndex;

    protected SubstitutionTextReader(Reader reader) {
        this.fReader = reader;
        this.fBuffer = new StringBuffer();
        this.fIndex = 0;
        this.fReadFromBuffer = false;
        this.fCharAfterWhiteSpace = -1;
        this.fWasWhiteSpace = true;
    }

    protected abstract String computeSubstitution(int var1) throws IOException;

    protected Reader getReader() {
        return this.fReader;
    }

    protected int nextChar() throws IOException {
        boolean bl = this.fReadFromBuffer = this.fBuffer.length() > 0;
        if (this.fReadFromBuffer) {
            char ch = this.fBuffer.charAt(this.fIndex++);
            if (this.fIndex >= this.fBuffer.length()) {
                this.fBuffer.setLength(0);
                this.fIndex = 0;
            }
            return ch;
        }
        int ch = this.fCharAfterWhiteSpace;
        if (ch == -1) {
            ch = this.fReader.read();
        }
        if (Character.isWhitespace((char)ch)) {
            while (Character.isWhitespace((char)(ch = this.fReader.read()))) {
            }
            if (ch != -1) {
                this.fCharAfterWhiteSpace = ch;
                return 32;
            }
        } else {
            this.fCharAfterWhiteSpace = -1;
        }
        return ch;
    }

    @Override
    public int read() throws IOException {
        int c;
        block0: do {
            c = this.nextChar();
            while (!this.fReadFromBuffer) {
                String s = this.computeSubstitution(c);
                if (s == null) continue block0;
                if (s.length() > 0) {
                    this.fBuffer.insert(0, s);
                }
                c = this.nextChar();
            }
        } while (this.fWasWhiteSpace && c == 32);
        this.fWasWhiteSpace = c == 32 || c == 13 || c == 10;
        return c;
    }

    @Override
    public boolean ready() throws IOException {
        return this.fReader.ready();
    }

    @Override
    public void close() throws IOException {
        this.fReader.close();
    }

    @Override
    public void reset() throws IOException {
        this.fReader.reset();
        this.fWasWhiteSpace = true;
        this.fCharAfterWhiteSpace = -1;
        this.fBuffer.setLength(0);
        this.fIndex = 0;
    }
}

