/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.histogram;

import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramUtils;
import org.eclipse.linuxtools.tmf.ui.views.histogram.HistogramView;
import org.eclipse.swt.widgets.Composite;

public class HistogramCurrentTimeControl
extends HistogramTextControl {
    public HistogramCurrentTimeControl(HistogramView parentView, Composite parent, int textStyle, int groupStyle) {
        this(parentView, parent, textStyle, groupStyle, "", HistogramUtils.nanosecondsToString(0L));
    }

    public HistogramCurrentTimeControl(HistogramView parentView, Composite parent, int textStyle, int groupStyle, String groupValue, String textValue) {
        super(parentView, parent, textStyle, groupStyle, groupValue, textValue);
    }

    @Override
    protected void updateValue() {
        String stringValue = this.fTextValue.getText();
        long value = HistogramUtils.stringToNanoseconds(stringValue);
        if (this.getValue() != value) {
            TmfExperiment exp = TmfExperiment.getCurrentExperiment();
            if (exp != null) {
                TmfTimeRange range = exp.getTimeRange();
                long startTime = range.getStartTime().normalize(0L, -9).getValue();
                long endTime = range.getEndTime().normalize(0L, -9).getValue();
                if (value < startTime) {
                    value = startTime;
                } else if (value > endTime) {
                    value = endTime;
                }
            }
            this.setValue(value);
            this.fParentView.updateCurrentEventTime(value);
        }
    }
}

