/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class TmfProjectElement
extends TmfProjectModelElement {
    private TmfTraceFolder fTraceFolder = null;
    private TmfExperimentFolder fExperimentFolder = null;

    public TmfProjectElement(String name, IProject project, ITmfProjectModelElement parent) {
        super(name, (IResource)project, parent);
    }

    public IProject getResource() {
        return (IProject)this.fResource;
    }

    @Override
    public void addChild(ITmfProjectModelElement child) {
        super.addChild(child);
        if (child instanceof TmfTraceFolder) {
            this.fTraceFolder = (TmfTraceFolder)child;
            return;
        }
        if (child instanceof TmfExperimentFolder) {
            this.fExperimentFolder = (TmfExperimentFolder)child;
            return;
        }
    }

    public TmfTraceFolder getTracesFolder() {
        return this.fTraceFolder;
    }

    public TmfExperimentFolder getExperimentsFolder() {
        return this.fExperimentFolder;
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow wbWindow = wb.getActiveWorkbenchWindow();
                if (wbWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = wbWindow.getActivePage();
                IViewReference[] iViewReferenceArray = activePage.getViewReferences();
                int n = iViewReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewReference = iViewReferenceArray[n2];
                    IViewPart viewPart = viewReference.getView(false);
                    if (viewPart instanceof CommonNavigator) {
                        CommonViewer commonViewer = ((CommonNavigator)viewPart).getCommonViewer();
                        commonViewer.refresh();
                    }
                    ++n2;
                }
            }
        });
    }

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            this.refresh();
        }
    }

    @Override
    public TmfProjectElement getProject() {
        return this;
    }
}

