/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.osgi.framework.Bundle;

public class TmfNavigatorLabelProvider
implements ICommonLabelProvider {
    private static final Image fFolderIcon = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final String fTraceIconFile = "icons/elcl16/trace.gif";
    private static final String fExperimentIconFile = "icons/elcl16/experiment.gif";
    private final Image fTraceFolderIcon = fFolderIcon;
    private final Image fExperimentFolderIcon = fFolderIcon;
    private final Image fDefaultTraceIcon;
    private final Image fExperimentIcon;

    public TmfNavigatorLabelProvider() {
        Bundle bundle = Activator.getDefault().getBundle();
        this.fDefaultTraceIcon = TmfNavigatorLabelProvider.loadIcon(bundle, fTraceIconFile);
        this.fExperimentIcon = TmfNavigatorLabelProvider.loadIcon(bundle, fExperimentIconFile);
    }

    private static Image loadIcon(Bundle bundle, String url) {
        Activator plugin = Activator.getDefault();
        String key = String.valueOf(bundle.getSymbolicName()) + "/" + url;
        Image icon = plugin.getImageRegistry().get(key);
        if (icon == null) {
            URL imageURL = bundle.getResource(url);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)imageURL);
            icon = descriptor.createImage();
            plugin.getImageRegistry().put(key, icon);
        }
        return icon;
    }

    public Image getImage(Object element) {
        if (element instanceof TmfTraceElement) {
            TmfTraceElement trace = (TmfTraceElement)element;
            String icon = null;
            try {
                String name = trace.getResource().getPersistentProperty(TmfCommonConstants.TRACEBUNDLE);
                icon = trace.getResource().getPersistentProperty(TmfCommonConstants.TRACEICON);
                if (name != null && icon != null) {
                    Bundle bundle = Platform.getBundle((String)name);
                    return TmfNavigatorLabelProvider.loadIcon(bundle, icon);
                }
            }
            catch (CoreException coreException) {}
            return this.fDefaultTraceIcon;
        }
        if (element instanceof TmfExperimentElement) {
            return this.fExperimentIcon;
        }
        if (element instanceof TmfExperimentFolder) {
            return this.fExperimentFolderIcon;
        }
        if (element instanceof TmfTraceFolder) {
            return this.fTraceFolderIcon;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TmfTraceFolder) {
            TmfTraceFolder folder = (TmfTraceFolder)element;
            return String.valueOf(folder.getName()) + " [" + folder.getTraces().size() + "]";
        }
        if (element instanceof TmfExperimentElement) {
            TmfExperimentElement folder = (TmfExperimentElement)element;
            return String.valueOf(folder.getName()) + " [" + folder.getTraces().size() + "]";
        }
        if (element instanceof TmfExperimentFolder) {
            TmfExperimentFolder folder = (TmfExperimentFolder)element;
            return String.valueOf(folder.getName()) + " [" + folder.getChildren().size() + "]";
        }
        if (element instanceof ITmfProjectModelElement) {
            return ((ITmfProjectModelElement)element).getName();
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return this.getText(anElement);
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }
}

