/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.makefile;

import java.net.URI;
import java.util.ArrayList;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IInferenceRule;
import org.eclipse.cdt.make.core.makefile.IMacroDefinition;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.core.makefile.IRule;
import org.eclipse.cdt.make.core.makefile.ITargetRule;
import org.eclipse.cdt.make.internal.core.makefile.Directive;
import org.eclipse.cdt.make.internal.core.makefile.Parent;

public abstract class AbstractMakefile
extends Parent
implements IMakefile {
    private URI filename;

    public AbstractMakefile(Directive parent) {
        super(parent);
    }

    @Override
    public abstract IDirective[] getBuiltins();

    @Override
    public IRule[] getRules() {
        IDirective[] stmts = this.getDirectives(true);
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        int i = 0;
        while (i < stmts.length) {
            if (stmts[i] instanceof IRule) {
                array.add(stmts[i]);
            }
            ++i;
        }
        return array.toArray(new IRule[0]);
    }

    @Override
    public IRule[] getRules(String target) {
        IRule[] rules = this.getRules();
        ArrayList<IRule> array = new ArrayList<IRule>(rules.length);
        int i = 0;
        while (i < rules.length) {
            if (rules[i].getTarget().equals(target)) {
                array.add(rules[i]);
            }
            ++i;
        }
        return array.toArray(new IRule[0]);
    }

    @Override
    public IInferenceRule[] getInferenceRules() {
        IRule[] rules = this.getRules();
        ArrayList<IRule> array = new ArrayList<IRule>(rules.length);
        int i = 0;
        while (i < rules.length) {
            if (rules[i] instanceof IInferenceRule) {
                array.add(rules[i]);
            }
            ++i;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    @Override
    public IInferenceRule[] getInferenceRules(String target) {
        IInferenceRule[] irules = this.getInferenceRules();
        ArrayList<IInferenceRule> array = new ArrayList<IInferenceRule>(irules.length);
        int i = 0;
        while (i < irules.length) {
            if (irules[i].getTarget().equals(target)) {
                array.add(irules[i]);
            }
            ++i;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    @Override
    public ITargetRule[] getTargetRules() {
        IRule[] trules = this.getRules();
        ArrayList<IRule> array = new ArrayList<IRule>(trules.length);
        int i = 0;
        while (i < trules.length) {
            if (trules[i] instanceof ITargetRule) {
                array.add(trules[i]);
            }
            ++i;
        }
        return array.toArray(new ITargetRule[0]);
    }

    @Override
    public ITargetRule[] getTargetRules(String target) {
        ITargetRule[] trules = this.getTargetRules();
        ArrayList<ITargetRule> array = new ArrayList<ITargetRule>(trules.length);
        int i = 0;
        while (i < trules.length) {
            if (trules[i].getTarget().equals(target)) {
                array.add(trules[i]);
            }
            ++i;
        }
        return array.toArray(new ITargetRule[0]);
    }

    @Override
    public IMacroDefinition[] getMacroDefinitions() {
        IDirective[] stmts = this.getDirectives(true);
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        int i = 0;
        while (i < stmts.length) {
            if (stmts[i] instanceof IMacroDefinition) {
                array.add(stmts[i]);
            }
            ++i;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    @Override
    public IMacroDefinition[] getMacroDefinitions(String name) {
        IMacroDefinition[] variables = this.getMacroDefinitions();
        ArrayList<IMacroDefinition> array = new ArrayList<IMacroDefinition>(variables.length);
        int i = 0;
        while (i < variables.length) {
            if (variables[i].getName().equals(name)) {
                array.add(variables[i]);
            }
            ++i;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    @Override
    public IMacroDefinition[] getBuiltinMacroDefinitions() {
        IDirective[] stmts = this.getBuiltins();
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        int i = 0;
        while (i < stmts.length) {
            if (stmts[i] instanceof IMacroDefinition) {
                array.add(stmts[i]);
            }
            ++i;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    @Override
    public IMacroDefinition[] getBuiltinMacroDefinitions(String name) {
        IMacroDefinition[] variables = this.getBuiltinMacroDefinitions();
        ArrayList<IMacroDefinition> array = new ArrayList<IMacroDefinition>(variables.length);
        int i = 0;
        while (i < variables.length) {
            if (variables[i].getName().equals(name)) {
                array.add(variables[i]);
            }
            ++i;
        }
        return array.toArray(new IMacroDefinition[0]);
    }

    public IInferenceRule[] getBuiltinInferenceRules() {
        IDirective[] stmts = this.getBuiltins();
        ArrayList<IDirective> array = new ArrayList<IDirective>(stmts.length);
        int i = 0;
        while (i < stmts.length) {
            if (stmts[i] instanceof IInferenceRule) {
                array.add(stmts[i]);
            }
            ++i;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    public IInferenceRule[] getBuiltinInferenceRules(String target) {
        IInferenceRule[] irules = this.getBuiltinInferenceRules();
        ArrayList<IInferenceRule> array = new ArrayList<IInferenceRule>(irules.length);
        int i = 0;
        while (i < irules.length) {
            if (irules[i].getTarget().equals(target)) {
                array.add(irules[i]);
            }
            ++i;
        }
        return array.toArray(new IInferenceRule[0]);
    }

    @Override
    public String expandString(String line) {
        return this.expandString(line, false);
    }

    @Override
    public String expandString(String line, boolean recursive) {
        int len = line.length();
        boolean foundDollar = false;
        boolean inMacro = false;
        StringBuffer buffer = new StringBuffer();
        StringBuffer macroName = new StringBuffer();
        int i = 0;
        while (i < len) {
            char c = line.charAt(i);
            switch (c) {
                case '$': {
                    if (foundDollar) {
                        buffer.append(c);
                        foundDollar = false;
                        break;
                    }
                    foundDollar = true;
                    break;
                }
                case '(': 
                case '{': {
                    if (foundDollar) {
                        inMacro = true;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                case ')': 
                case '}': {
                    String result;
                    IMacroDefinition[] defs;
                    String name;
                    if (inMacro) {
                        name = macroName.toString();
                        if (name.length() > 0) {
                            defs = this.getMacroDefinitions(name);
                            if (defs.length == 0) {
                                defs = this.getBuiltinMacroDefinitions(name);
                            }
                            if (defs.length > 0) {
                                result = defs[0].getValue().toString();
                                if (result.indexOf(36) != -1 && recursive) {
                                    result = this.expandString(result, recursive);
                                }
                                buffer.append(result);
                            } else {
                                buffer.append('$').append('(').append(name).append(')');
                            }
                        }
                        macroName.setLength(0);
                        inMacro = false;
                        break;
                    }
                    buffer.append(c);
                    break;
                }
                default: {
                    String result;
                    IMacroDefinition[] defs;
                    String name;
                    if (inMacro) {
                        macroName.append(c);
                    } else if (foundDollar) {
                        name = String.valueOf(c);
                        defs = this.getMacroDefinitions(name);
                        if (defs.length == 0) {
                            defs = this.getBuiltinMacroDefinitions(name);
                        }
                        if (defs.length > 0) {
                            result = defs[0].getValue().toString();
                            if (result.indexOf(36) != -1 && recursive) {
                                result = this.expandString(result, recursive);
                            }
                            buffer.append(result);
                        } else {
                            buffer.append('$').append(c);
                        }
                        inMacro = false;
                    } else {
                        buffer.append(c);
                    }
                    foundDollar = false;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public URI getFileURI() {
        return this.filename;
    }

    public void setFileURI(URI filename) {
        this.filename = filename;
    }

    @Override
    public IMakefile getMakefile() {
        return this;
    }
}

