/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui.auth;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.UserAuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.ui.dialogs.CredentialsDialog;
import org.eclipse.mylyn.internal.commons.repositories.ui.auth.AbstractCredentialsProviderUi;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCredentialsProviderUi
extends AbstractCredentialsProviderUi<UserCredentials> {
    private UserCredentials credentials;

    @Override
    public UserCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public IStatus open(Shell shell, AuthenticationRequest<AuthenticationType<UserCredentials>> request) {
        CredentialsDialog dialog = new CredentialsDialog(shell, CredentialsDialog.Mode.USER);
        UserCredentials oldCredentials = (UserCredentials)request.getLocation().getCredentials(request.getAuthenticationType());
        if (oldCredentials != null) {
            dialog.setUsername(oldCredentials.getUserName());
            dialog.setDomain(oldCredentials.getDomain() != null ? oldCredentials.getDomain() : "");
            dialog.setPassword(oldCredentials.getPassword());
            dialog.setSavePassword(oldCredentials.getSavePassword());
        }
        if (request instanceof UserAuthenticationRequest) {
            dialog.setNeedsDomain(((UserAuthenticationRequest)request).needsDomain());
        }
        dialog.create();
        dialog.setTitle(NLS.bind((String)"Credentials for {0}", (Object)request.getLocation().getLabel()));
        if (request.getMessage() != null) {
            dialog.setMessage(request.getMessage());
        } else {
            dialog.setMessage(this.getDefaultMessage(request));
        }
        int resultCode = dialog.open();
        if (resultCode == 0) {
            this.credentials = new UserCredentials(dialog.getUserName(), dialog.getPassword(), dialog.getDomain(), dialog.getSavePassword());
            request.getLocation().setCredentials(request.getAuthenticationType(), (AuthenticationCredentials)this.credentials);
            if (request.getAuthenticationType() == AuthenticationType.REPOSITORY) {
                request.getLocation().setUserName(dialog.getUserName());
            }
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private String getDefaultMessage(AuthenticationRequest<AuthenticationType<UserCredentials>> request) {
        AuthenticationType authType = request.getAuthenticationType();
        if (AuthenticationType.REPOSITORY == authType) {
            return "Enter repository credentials";
        }
        if (AuthenticationType.HTTP == authType) {
            return "Enter HTTP credentials";
        }
        if (AuthenticationType.PROXY == authType) {
            return "Enter proxy credentials";
        }
        return null;
    }
}

