/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IBaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.IUstProviderInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.BaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.TraceInfo;

public class UstProviderInfo
extends TraceInfo
implements IUstProviderInfo {
    private int fPid = 0;
    private final List<IBaseEventInfo> fEvents = new ArrayList<IBaseEventInfo>();

    public UstProviderInfo(String name) {
        super(name);
    }

    public UstProviderInfo(UstProviderInfo other) {
        super(other);
        this.fPid = other.fPid;
        for (IBaseEventInfo event : other.fEvents) {
            if (event instanceof BaseEventInfo) {
                this.fEvents.add(new BaseEventInfo((BaseEventInfo)event));
                continue;
            }
            this.fEvents.add(event);
        }
    }

    @Override
    public int getPid() {
        return this.fPid;
    }

    @Override
    public void setPid(int pid) {
        this.fPid = pid;
    }

    @Override
    public IBaseEventInfo[] getEvents() {
        return this.fEvents.toArray(new IBaseEventInfo[this.fEvents.size()]);
    }

    @Override
    public void setEvents(List<IBaseEventInfo> events) {
        for (IBaseEventInfo eventInfo : events) {
            this.fEvents.add(eventInfo);
        }
    }

    @Override
    public void addEvent(IBaseEventInfo event) {
        this.fEvents.add(event);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fEvents == null ? 0 : this.fEvents.hashCode());
        result = 31 * result + this.fPid;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UstProviderInfo other = (UstProviderInfo)obj;
        if (this.fEvents == null ? other.fEvents != null : !this.fEvents.equals(other.fEvents)) {
            return false;
        }
        return this.fPid == other.fPid;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[EventInfo(");
        output.append(super.toString());
        output.append(",PID=");
        output.append(this.fPid);
        output.append(",Events=");
        if (this.fEvents.isEmpty()) {
            output.append("None");
        } else {
            for (IBaseEventInfo event : this.fEvents) {
                output.append(event.toString());
            }
        }
        output.append(")]");
        return output.toString();
    }
}

