/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.workbench.browser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.commons.workbench.browser.AbstractUrlHandler;
import org.eclipse.mylyn.internal.commons.workbench.CommonsWorkbenchPlugin;
import org.eclipse.mylyn.internal.commons.workbench.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class BrowserUtil {
    public static final int NO_RICH_EDITOR = 131072;

    public static void openUrl(String location) {
        BrowserUtil.openUrl(location, 0);
    }

    public static void openUrl(String location, int customFlags) {
        IWorkbenchPage page = null;
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        BrowserUtil.openUrl(page, location, customFlags);
    }

    public static EditorHandle openUrl(IWorkbenchPage page, String location, int customFlags) {
        try {
            return BrowserUtil.openUrlInternal(page, location, customFlags);
        }
        catch (PartInitException e) {
            Status status = new Status(4, "org.eclipse.mylyn.commons.workbench", Messages.WorkbenchUtil_Browser_Initialization_Failed, (Throwable)e);
            CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            if (!CoreUtil.TEST_MODE) {
                MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
            }
            return new EditorHandle((IStatus)status);
        }
        catch (MalformedURLException e) {
            if (location != null && location.trim().equals("")) {
                Status status = new Status(2, "org.eclipse.mylyn.commons.workbench", Messages.WorkbenchUtil_No_URL_Error, (Throwable)e);
                if (!CoreUtil.TEST_MODE) {
                    MessageDialog.openWarning((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
                } else {
                    CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)status);
                }
                return new EditorHandle((IStatus)status);
            }
            Status status = new Status(4, "org.eclipse.mylyn.commons.workbench", NLS.bind((String)Messages.WorkbenchUtil_Invalid_URL_Error, (Object)location), (Throwable)e);
            if (!CoreUtil.TEST_MODE) {
                MessageDialog.openError((Shell)WorkbenchUtil.getShell(), (String)Messages.WorkbenchUtil_Open_Location_Title, (String)status.getMessage());
            } else {
                CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
            return new EditorHandle((IStatus)status);
        }
    }

    private static EditorHandle openUrlInternal(IWorkbenchPage page, String location, int customFlags) throws MalformedURLException, PartInitException {
        EditorHandle handle;
        if (location != null && (customFlags & 0x80) == 0 && (customFlags & 0x20000) == 0 && page != null && (handle = BrowserUtil.openUrlByHandler(page, location, customFlags)) != null) {
            return handle;
        }
        URL url = null;
        if (location != null) {
            url = new URL(location);
        }
        if (WebBrowserPreference.getBrowserChoice() == 1 || (customFlags & 0x80) != 0) {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(url);
            return new BrowserHandle(browser);
        }
        int flags = customFlags;
        flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
        String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
        IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
        browser.openURL(url);
        return new BrowserHandle(browser);
    }

    private static EditorHandle openUrlByHandler(final IWorkbenchPage page, final String location, final int customFlags) {
        for (final AbstractUrlHandler handler : UrlHandlerInitializer.handlers) {
            final AtomicReference result = new AtomicReference();
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    result.set(handler.openUrl(page, location, customFlags));
                }

                public void handleException(Throwable exception) {
                    CommonsWorkbenchPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.mylyn.commons.workbench", NLS.bind((String)"Unexpected error in {0} while opening URL ''{1}''", handler.getClass(), (Object)location)));
                }
            });
            if (result.get() == null) continue;
            return (EditorHandle)result.get();
        }
        return null;
    }

    static class BrowserHandle
    extends EditorHandle {
        private final IWebBrowser browser;

        public BrowserHandle(IWebBrowser browser) {
            super(Status.OK_STATUS);
            this.browser = browser;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWebBrowser.class) {
                return this.browser;
            }
            return super.getAdapter(adapter);
        }
    }

    static class UrlHandlerInitializer {
        private static List<AbstractUrlHandler> handlers;

        static {
            ExtensionPointReader reader = new ExtensionPointReader("org.eclipse.mylyn.commons.workbench", "urlHandlers", "handler", AbstractUrlHandler.class);
            IStatus status = reader.read();
            if (!status.isOK()) {
                StatusHandler.log((IStatus)status);
            }
            handlers = reader.getItems();
            Collections.sort(handlers, new Comparator<AbstractUrlHandler>(){

                @Override
                public int compare(AbstractUrlHandler o1, AbstractUrlHandler o2) {
                    return o2.getPriority() - o1.getPriority();
                }
            });
        }

        UrlHandlerInitializer() {
        }
    }
}

