/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class CSSResourcesHelpers {
    public static String getCSSValueKey(CSSValue value) {
        if (value instanceof CSS2FontProperties) {
            return CSSResourcesHelpers.getCSSFontPropertiesKey((CSS2FontProperties)value);
        }
        if (value.getCssValueType() == 1) {
            return CSSResourcesHelpers.getCSSPrimitiveValueKey((CSSPrimitiveValue)value);
        }
        return null;
    }

    public static String getCSSPrimitiveValueKey(CSSPrimitiveValue value) {
        switch (value.getPrimitiveType()) {
            case 20: 
            case 21: {
                RGBColor rgbColor;
                String s = value.getStringValue();
                if (CSS2ColorHelper.isColorName(s) && (rgbColor = CSS2ColorHelper.getRGBColor(s)) != null) {
                    return CSSResourcesHelpers.getCSSRGBColorKey(rgbColor);
                }
                return value.getStringValue();
            }
            case 25: {
                RGBColor rgbColor = value.getRGBColorValue();
                return CSSResourcesHelpers.getCSSRGBColorKey(rgbColor);
            }
        }
        return null;
    }

    public static String getCSSRGBColorKey(RGBColor rgbColor) {
        if (rgbColor == null) {
            return null;
        }
        String rgb = String.valueOf((int)rgbColor.getGreen().getFloatValue((short)1)) + "_";
        rgb = String.valueOf(rgb) + (int)rgbColor.getRed().getFloatValue((short)1) + "_";
        rgb = String.valueOf(rgb) + (int)rgbColor.getBlue().getFloatValue((short)1);
        return rgb;
    }

    public static String getCSSFontPropertiesKey(CSS2FontProperties fontProperties) {
        return fontProperties.getFamily() + "_" + fontProperties.getSize() + "_" + fontProperties.getStyle() + "_" + fontProperties.getWeight();
    }

    public static Object getResource(IResourcesRegistry resourcesRegistry, Object type, CSSPrimitiveValue value) {
        String key = CSSResourcesHelpers.getCSSPrimitiveValueKey(value);
        return CSSResourcesHelpers.getResource(resourcesRegistry, type, key);
    }

    public static Object getResource(IResourcesRegistry resourcesRegistry, Object type, String key) {
        if (key == null) {
            return null;
        }
        if (resourcesRegistry != null) {
            return resourcesRegistry.getResource(type, key);
        }
        return null;
    }

    public static void registerResource(IResourcesRegistry resourcesRegistry, Object type, CSSPrimitiveValue value, Object resource) {
        String key;
        if (resourcesRegistry != null && (key = CSSResourcesHelpers.getCSSPrimitiveValueKey(value)) != null) {
            resourcesRegistry.registerResource(type, key, resource);
        }
    }

    public static void registerResource(IResourcesRegistry resourcesRegistry, Object type, String key, Object resource) {
        if (key == null) {
            return;
        }
        if (resourcesRegistry != null) {
            resourcesRegistry.registerResource(type, key, resource);
        }
    }
}

