/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.ICheckersRegistry;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.internal.core.CodanRunner;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.dialogs.CustomizeProblemDialog;
import org.eclipse.cdt.codan.internal.ui.preferences.FieldEditorOverlayPage;
import org.eclipse.cdt.codan.internal.ui.preferences.ProblemsTreeEditor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CodanPreferencePage
extends FieldEditorOverlayPage
implements IWorkbenchPreferencePage {
    private static final String EMPTY_STRING = "";
    private IProblemProfile profile;
    private ISelectionChangedListener problemSelectionListener;
    private ArrayList<IProblem> selectedProblems;
    private Button infoButton;
    private ProblemsTreeEditor checkedTreeEditor;

    public CodanPreferencePage() {
        super(1);
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.cdt.codan.core"));
        this.problemSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (CodanPreferencePage.this.infoButton != null && event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection s = (ITreeSelection)event.getSelection();
                    ArrayList<IProblem> list = new ArrayList<IProblem>();
                    for (Object o : s) {
                        if (!(o instanceof IProblem)) continue;
                        list.add((IProblem)o);
                    }
                    CodanPreferencePage.this.setSelectedProblems(list);
                }
            }
        };
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.cdt.codan.internal.ui.preferences.CodanPreferencePage";
    }

    public void createFieldEditors() {
        this.checkedTreeEditor = new ProblemsTreeEditor(this.getFieldEditorParent(), this.profile);
        this.addField(this.checkedTreeEditor);
        this.checkedTreeEditor.getTreeViewer().addSelectionChangedListener(this.problemSelectionListener);
        this.checkedTreeEditor.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CodanPreferencePage.this.openCustomizeDialog();
            }
        });
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        this.checkedTreeEditor.getTreeViewer().getControl().setLayoutData((Object)layoutData);
    }

    @Override
    protected Control createContents(Composite parent) {
        this.profile = this.isPropertyPage() ? this.getRegistry().getResourceProfileWorkingCopy((IResource)this.getElement()) : this.getRegistry().getWorkspaceProfile();
        Composite comp = (Composite)super.createContents(parent);
        this.createInfoControl(comp);
        return comp;
    }

    private void createInfoControl(Composite comp) {
        Composite info = new Composite(comp, 0);
        info.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        info.setLayout((Layout)layout);
        this.infoButton = new Button(info, 8);
        this.infoButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(0x1000008, 1).create());
        this.infoButton.setText(CodanUIMessages.CodanPreferencePage_Customize);
        this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodanPreferencePage.this.openCustomizeDialog();
            }
        });
        this.restoreWidgetValues();
    }

    protected void setSelectedProblems(ArrayList<IProblem> list) {
        this.selectedProblems = list;
        this.updateProblemInfo();
    }

    protected ICheckersRegistry getRegistry() {
        return CodanRuntime.getInstance().getCheckersRegistry();
    }

    @Override
    public boolean performOk() {
        this.saveWidgetValues();
        IResource resource = (IResource)this.getElement();
        this.getRegistry().updateProfile(resource, null);
        boolean success = super.performOk();
        if (success) {
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            CodanRunner.asynchronouslyRemoveMarkersForDisabledProblems((IResource)resource);
        }
        return success;
    }

    private void saveWidgetValues() {
        String id = !this.hasSelectedProblems() ? EMPTY_STRING : this.selectedProblems.get(0).getId();
        this.getDialogSettings().put(this.getWidgetId(), id);
    }

    private void restoreWidgetValues() {
        String id = this.getDialogSettings().get(this.getWidgetId());
        if (id != null && !id.isEmpty() && this.checkedTreeEditor != null) {
            IProblem problem = this.profile.findProblem(id);
            if (problem != null) {
                this.checkedTreeEditor.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)problem), true);
            }
        } else {
            this.setSelectedProblems(null);
        }
        this.updateProblemInfo();
    }

    private IDialogSettings getDialogSettings() {
        return CodanUIActivator.getDefault().getDialogSettings();
    }

    protected String getWidgetId() {
        return String.valueOf(this.getPageId()) + ".selection";
    }

    private void updateProblemInfo() {
        this.infoButton.setEnabled(this.hasSelectedProblems());
    }

    public void init(IWorkbench workbench) {
    }

    protected void openCustomizeDialog() {
        if (!this.hasSelectedProblems()) {
            return;
        }
        IProblem[] selected = this.selectedProblems.toArray(new IProblem[this.selectedProblems.size()]);
        CustomizeProblemDialog dialog = new CustomizeProblemDialog(this.getShell(), selected, (IResource)this.getElement());
        dialog.open();
        this.checkedTreeEditor.getTreeViewer().refresh(true);
    }

    private boolean hasSelectedProblems() {
        return this.selectedProblems != null && !this.selectedProblems.isEmpty();
    }
}

