/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnViewerSorter<V extends ColumnViewer, I extends Item>
extends ViewerSorter {
    abstract I getSortColumn(V var1);

    abstract int getSortDirection(V var1);

    abstract int getColumnIndex(V var1, I var2);

    public int compare(Viewer viewer, Object e1, Object e2) {
        Assert.isLegal((boolean)(viewer instanceof ColumnViewer));
        ColumnViewer columnViewer = (ColumnViewer)viewer;
        I column = this.getSortColumn(columnViewer);
        if (column != null) {
            int index = this.getColumnIndex(columnViewer, column);
            int result = this.compare(columnViewer, e1, e2, index);
            if (this.getSortDirection(columnViewer) == 128) {
                return -result;
            }
            return result;
        }
        return this.compareDefault(columnViewer, e1, e2);
    }

    protected int compareDefault(V viewer, Object e1, Object e2) {
        return super.compare(viewer, e1, e2);
    }

    public int compare(V viewer, Object e1, Object e2, int columnIndex) {
        String name2;
        String name1;
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (viewer == null || !(viewer instanceof ContentViewer)) {
            name1 = e1.toString();
            name2 = e2.toString();
        } else {
            CellLabelProvider prov = viewer.getLabelProvider(columnIndex);
            if (prov instanceof ILabelProvider) {
                ILabelProvider lprov = (ILabelProvider)prov;
                name1 = lprov.getText(e1);
                name2 = lprov.getText(e2);
            } else {
                name1 = e1.toString();
                name2 = e2.toString();
            }
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        return this.getComparator().compare(name1, name2);
    }
}

