/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitBlobMapping;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitContainerMapping;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitRepositoryMapping;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitTreeMapping;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.HasProjects;

public abstract class GitObjectMapping
extends ResourceMapping {
    private final GitModelObject object;

    public static ResourceMapping create(GitModelObject object) {
        if (object instanceof GitModelBlob) {
            return new GitBlobMapping((GitModelBlob)object);
        }
        if (object instanceof GitModelTree) {
            return new GitTreeMapping((GitModelTree)object);
        }
        if (object instanceof GitModelObjectContainer) {
            return new GitContainerMapping((GitModelObjectContainer)object);
        }
        if (object instanceof GitModelRepository) {
            return new GitRepositoryMapping((GitModelRepository)object);
        }
        return null;
    }

    protected GitObjectMapping(GitModelObject parent) {
        this.object = parent;
    }

    public boolean contains(ResourceMapping mapping) {
        if (mapping.getModelProviderId().equals(this.getModelProviderId())) {
            GitModelObject obj = (GitModelObject)((Object)mapping.getModelObject());
            return obj.repositoryHashCode() == this.object.repositoryHashCode();
        }
        return false;
    }

    public Object getModelObject() {
        return this.object;
    }

    public String getModelProviderId() {
        return "org.eclipse.egit.ui.changeSetModel";
    }

    private IProject getProject(IResource resource) {
        return resource != null ? resource.getProject() : null;
    }

    public IProject[] getProjects() {
        IProject[] projects = null;
        if (!this.object.isContainer()) {
            IProject project = this.getProject((IResource)ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.object.getLocation()));
            if (project != null) {
                projects = new IProject[]{project};
            }
        } else if (this.object instanceof GitModelTree) {
            IProject project = this.getProject((IResource)ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.object.getLocation()));
            if (project != null) {
                projects = new IProject[]{project};
            }
        } else if (this.object instanceof HasProjects) {
            projects = ((HasProjects)((Object)this.object)).getProjects();
        }
        return projects != null ? projects : new IProject[]{};
    }
}

