/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffChangedListener;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.op.CommitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.EgitUiEditorUtils;
import org.eclipse.egit.ui.internal.actions.BooleanPrefAction;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.commit.CommitMessageHistory;
import org.eclipse.egit.ui.internal.commit.CommitProposalProcessor;
import org.eclipse.egit.ui.internal.commit.CommitUI;
import org.eclipse.egit.ui.internal.components.ToggleableWarningLabel;
import org.eclipse.egit.ui.internal.decorators.ProblemLabelDecorator;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageArea;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponent;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentStateManager;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.egit.ui.internal.operations.DeletePathsOperationUI;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingViewContentProvider;
import org.eclipse.egit.ui.internal.staging.StagingViewLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.egit.ui.StagingView";
    private static final String EMPTY_STRING = "";
    private Form form;
    private Section stagedSection;
    private Section unstagedSection;
    private Section commitMessageSection;
    private TableViewer stagedTableViewer;
    private TableViewer unstagedTableViewer;
    private ToggleableWarningLabel warningLabel;
    private SpellcheckableMessageArea commitMessageText;
    private Text committerText;
    private Text authorText;
    private Action commitAction;
    private CommitMessageComponent commitMessageComponent;
    private boolean reactOnSelection = true;
    private ISelectionListener selectionChangedListener;
    private Repository currentRepository;
    private final IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!"GitRepositoriesView.GitDirectories".equals(event.getKey())) {
                return;
            }
            Repository repo = StagingView.this.currentRepository;
            if (repo == null) {
                return;
            }
            if (Activator.getDefault().getRepositoryUtil().contains(repo)) {
                return;
            }
            StagingView.this.reload(null);
        }
    };
    private Action signedOffByAction;
    private Action addChangeIdAction;
    private Action amendPreviousCommitAction;
    private Action openNewCommitsAction;
    private Action columnLayoutAction;
    private Action fileNameModeAction;
    private Action refreshAction;
    private SashForm stagingSashForm;
    private IndexDiffChangedListener myIndexDiffListener = new IndexDiffChangedListener(){

        public void indexDiffChanged(Repository repository, IndexDiffData indexDiffData) {
            StagingView.this.reload(repository);
        }
    };
    private IndexDiffCacheEntry cacheEntry;
    private UndoRedoActionGroup undoRedoActionGroup;

    public void createPartControl(Composite parent) {
        IWorkbenchPart part;
        GridLayoutFactory.fillDefaults().applyTo(parent);
        final FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolkit.dispose();
            }
        });
        this.form = toolkit.createForm(parent);
        Image repoImage = UIIcons.REPOSITORY.createImage();
        UIUtils.hookDisposal((Widget)this.form, (Resource)repoImage);
        this.form.setImage(repoImage);
        this.form.setText(UIText.StagingView_NoSelectionTitle);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.form);
        toolkit.decorateFormHeading(this.form);
        GridLayoutFactory.swtDefaults().applyTo(this.form.getBody());
        SashForm horizontalSashForm = new SashForm(this.form.getBody(), 0);
        toolkit.adapt((Control)horizontalSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)horizontalSashForm);
        this.stagingSashForm = new SashForm((Composite)horizontalSashForm, this.getStagingFormOrientation());
        toolkit.adapt((Control)this.stagingSashForm, true, true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.stagingSashForm);
        this.unstagedSection = toolkit.createSection((Composite)this.stagingSashForm, 256);
        Composite unstagedTableComposite = toolkit.createComposite((Composite)this.unstagedSection);
        toolkit.paintBordersFor(unstagedTableComposite);
        this.unstagedSection.setClient((Control)unstagedTableComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(unstagedTableComposite);
        this.unstagedTableViewer = new TableViewer(toolkit.createTable(unstagedTableComposite, 65538));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.unstagedTableViewer.getControl());
        this.unstagedTableViewer.getTable().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.unstagedTableViewer.getTable().setLinesVisible(true);
        this.unstagedTableViewer.setLabelProvider(this.createLabelProvider(this.unstagedTableViewer));
        this.unstagedTableViewer.setContentProvider((IContentProvider)new StagingViewContentProvider(true));
        this.unstagedTableViewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new StagingDragListener((ISelectionProvider)this.unstagedTableViewer));
        this.unstagedTableViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                IStructuredSelection selection;
                if (event.data instanceof IStructuredSelection && (selection = (IStructuredSelection)event.data).getFirstElement() instanceof StagingEntry) {
                    StagingView.this.unstage(selection);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 2;
            }
        });
        this.unstagedTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StagingView.this.compareWith(event);
            }
        });
        this.commitMessageSection = toolkit.createSection((Composite)horizontalSashForm, 256);
        this.commitMessageSection.setText(UIText.StagingView_CommitMessage);
        Composite commitMessageComposite = toolkit.createComposite((Composite)this.commitMessageSection);
        this.commitMessageSection.setClient((Control)commitMessageComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(commitMessageComposite);
        this.warningLabel = new ToggleableWarningLabel(commitMessageComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).exclude(true).applyTo((Control)this.warningLabel);
        Composite commitMessageTextComposite = toolkit.createComposite(commitMessageComposite);
        toolkit.paintBordersFor(commitMessageTextComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitMessageTextComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).extendedMargins(2, 2, 2, 2).applyTo(commitMessageTextComposite);
        final CommitProposalProcessor commitProposalProcessor = new CommitProposalProcessor(){

            @Override
            protected Collection<String> computeFileNameProposals() {
                return StagingView.this.getStagedFileNames();
            }

            @Override
            protected Collection<String> computeMessageProposals() {
                return CommitMessageHistory.getCommitHistory();
            }
        };
        this.commitMessageText = new CommitMessageArea(commitMessageTextComposite, EMPTY_STRING, toolkit.getBorderStyle()){

            protected CommitProposalProcessor getCommitProposalProcessor() {
                return commitProposalProcessor;
            }

            protected IHandlerService getHandlerService() {
                return (IHandlerService)StagingView.this.getSite().getService(IHandlerService.class);
            }
        };
        this.commitMessageText.setData("FormWidgetFactory.drawBorder", "textBorder");
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.commitMessageText);
        UIUtils.addBulbDecorator((Control)this.commitMessageText.getTextWidget(), UIText.CommitDialog_ContentAssist);
        Composite composite = toolkit.createComposite(commitMessageComposite);
        toolkit.paintBordersFor(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(composite);
        toolkit.createLabel(composite, UIText.StagingView_Author).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.authorText = toolkit.createText(composite, null);
        this.authorText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.authorText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        toolkit.createLabel(composite, UIText.StagingView_Committer).setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TB_TOGGLE"));
        this.committerText = toolkit.createText(composite, null);
        this.committerText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.committerText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.stagedSection = toolkit.createSection((Composite)this.stagingSashForm, 256);
        Composite stagedTableComposite = toolkit.createComposite((Composite)this.stagedSection);
        toolkit.paintBordersFor(stagedTableComposite);
        this.stagedSection.setClient((Control)stagedTableComposite);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(stagedTableComposite);
        this.stagedTableViewer = new TableViewer(toolkit.createTable(stagedTableComposite, 65538));
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.stagedTableViewer.getControl());
        this.stagedTableViewer.getTable().setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.stagedTableViewer.getTable().setLinesVisible(true);
        this.stagedTableViewer.setLabelProvider(this.createLabelProvider(this.stagedTableViewer));
        this.stagedTableViewer.setContentProvider((IContentProvider)new StagingViewContentProvider(false));
        this.stagedTableViewer.addDragSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()}, (DragSourceListener)new StagingDragListener((ISelectionProvider)this.stagedTableViewer));
        this.stagedTableViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                IStructuredSelection selection;
                if (event.data instanceof IStructuredSelection && (selection = (IStructuredSelection)event.data).getFirstElement() instanceof StagingEntry) {
                    StagingView.this.stage(selection);
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.detail = 2;
            }
        });
        this.stagedTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StagingView.this.compareWith(event);
            }
        });
        this.selectionChangedListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (!StagingView.this.reactOnSelection || part == StagingView.this.getSite().getPart()) {
                    return;
                }
                if (part instanceof IEditorPart) {
                    IEditorInput input = ((IEditorPart)part).getEditorInput();
                    if (input instanceof IFileEditorInput) {
                        StagingView.this.reactOnSelection((ISelection)new StructuredSelection((Object)((IFileEditorInput)input).getFile()));
                    }
                } else {
                    StagingView.this.reactOnSelection(selection);
                }
            }
        };
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        if (preferenceStore.contains("StagingView_SyncWithSelection")) {
            this.reactOnSelection = preferenceStore.getBoolean("StagingView_SyncWithSelection");
        } else {
            preferenceStore.setDefault("StagingView_SyncWithSelection", true);
        }
        new InstanceScope().getNode(org.eclipse.egit.core.Activator.getPluginId()).addPreferenceChangeListener(this.prefListener);
        this.updateSectionText();
        this.updateToolbar();
        this.enableCommitWidgets(false);
        this.createPopupMenu(this.unstagedTableViewer);
        this.createPopupMenu(this.stagedTableViewer);
        ICommitMessageComponentNotifications listener = new ICommitMessageComponentNotifications(){

            public void updateSignedOffToggleSelection(boolean selection) {
                StagingView.this.signedOffByAction.setChecked(selection);
            }

            public void updateChangeIdToggleSelection(boolean selection) {
                StagingView.this.addChangeIdAction.setChecked(selection);
            }
        };
        this.commitMessageComponent = new CommitMessageComponent(listener);
        this.commitMessageComponent.attachControls(this.commitMessageText, this.authorText, this.committerText);
        this.commitMessageText.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (UIUtils.isSubmitKeyEvent((KeyEvent)event)) {
                    event.doit = false;
                    StagingView.this.commit();
                }
            }
        });
        this.commitMessageText.getTextWidget().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                StagingView.this.commitAction.setToolTipText(MessageFormat.format(UIText.StagingView_CommitToolTip, UIUtils.SUBMIT_KEY_STROKE.format()));
            }

            public void focusLost(FocusEvent e) {
                StagingView.this.commitAction.setToolTipText(null);
            }
        });
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StagingView.this.updateMessage();
            }
        };
        this.authorText.addModifyListener(modifyListener);
        this.committerText.addModifyListener(modifyListener);
        IWorkbenchPartSite site = this.getSite();
        ISelectionService srv = (ISelectionService)site.getService(ISelectionService.class);
        srv.addPostSelectionListener(this.selectionChangedListener);
        ISelection selection = srv.getSelection();
        if (selection != null && !selection.isEmpty() && (part = site.getPage().getActivePart()) != null) {
            this.selectionChangedListener.selectionChanged(part, selection);
        }
        site.setSelectionProvider((ISelectionProvider)this.unstagedTableViewer);
    }

    private int getStagingFormOrientation() {
        boolean columnLayout = Activator.getDefault().getPreferenceStore().getBoolean("StagingView_ColumnLayout");
        if (columnLayout) {
            return 256;
        }
        return 512;
    }

    private void enableCommitWidgets(boolean enabled) {
        if (!enabled) {
            this.commitMessageText.setText(EMPTY_STRING);
            this.committerText.setText(EMPTY_STRING);
            this.authorText.setText(EMPTY_STRING);
        }
        this.commitMessageText.setEnabled(enabled);
        this.committerText.setEnabled(enabled);
        this.authorText.setEnabled(enabled);
        this.refreshAction.setEnabled(enabled);
        this.amendPreviousCommitAction.setEnabled(enabled);
        this.signedOffByAction.setEnabled(enabled);
        this.addChangeIdAction.setEnabled(enabled);
        this.commitAction.setEnabled(enabled);
    }

    private void updateToolbar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = actionBars.getToolBarManager();
        this.refreshAction = new Action(UIText.StagingView_Refresh, 1){

            public void run() {
                if (StagingView.this.cacheEntry != null) {
                    StagingView.this.cacheEntry.refreshResourcesAndIndexDiff();
                }
            }
        };
        this.refreshAction.setImageDescriptor(UIIcons.ELCL16_REFRESH);
        toolbar.add((IAction)this.refreshAction);
        BooleanPrefAction linkSelectionAction = new BooleanPrefAction((IPersistentPreferenceStore)this.getPreferenceStore(), "StagingView_SyncWithSelection", UIText.StagingView_LinkSelection){

            public void apply(boolean value) {
                StagingView.this.reactOnSelection = value;
            }
        };
        linkSelectionAction.setImageDescriptor(UIIcons.ELCL16_SYNCED);
        toolbar.add((IAction)linkSelectionAction);
        toolbar.add((IContributionItem)new Separator());
        this.amendPreviousCommitAction = new Action(UIText.StagingView_Ammend_Previous_Commit, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setAmendingButtonSelection(this.isChecked());
                StagingView.this.updateMessage();
            }
        };
        this.amendPreviousCommitAction.setImageDescriptor(UIIcons.AMEND_COMMIT);
        toolbar.add((IAction)this.amendPreviousCommitAction);
        this.signedOffByAction = new Action(UIText.StagingView_Add_Signed_Off_By, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setSignedOffButtonSelection(this.isChecked());
            }
        };
        this.signedOffByAction.setImageDescriptor(UIIcons.SIGNED_OFF);
        toolbar.add((IAction)this.signedOffByAction);
        this.addChangeIdAction = new Action(UIText.StagingView_Add_Change_ID, 2){

            public void run() {
                StagingView.this.commitMessageComponent.setChangeIdButtonSelection(this.isChecked());
            }
        };
        this.addChangeIdAction.setImageDescriptor(UIIcons.GERRIT);
        toolbar.add((IAction)this.addChangeIdAction);
        toolbar.add((IContributionItem)new Separator());
        this.commitAction = new Action(UIText.StagingView_Commit, 1){

            public void run() {
                StagingView.this.commit();
            }
        };
        this.commitAction.setImageDescriptor(UIIcons.COMMIT);
        toolbar.add((IAction)this.commitAction);
        this.openNewCommitsAction = new Action(UIText.StagingView_OpenNewCommits, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ShowNewCommits", this.isChecked());
            }
        };
        this.openNewCommitsAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ShowNewCommits"));
        this.columnLayoutAction = new Action(UIText.StagingView_ColumnLayout, 2){

            public void run() {
                StagingView.this.getPreferenceStore().setValue("StagingView_ColumnLayout", this.isChecked());
                StagingView.this.stagingSashForm.setOrientation(this.isChecked() ? 256 : 512);
            }
        };
        this.columnLayoutAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_ColumnLayout"));
        this.fileNameModeAction = new Action(UIText.StagingView_ShowFileNamesFirst, 2){

            public void run() {
                boolean enable = this.isChecked();
                StagingView.this.getLabelProvider((ContentViewer)StagingView.this.stagedTableViewer).setFileNameMode(enable);
                StagingView.this.getLabelProvider((ContentViewer)StagingView.this.unstagedTableViewer).setFileNameMode(enable);
                StagingView.this.stagedTableViewer.refresh();
                StagingView.this.unstagedTableViewer.refresh();
                StagingView.this.getPreferenceStore().setValue("StagingView_FileNameMode", enable);
            }
        };
        this.fileNameModeAction.setChecked(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        IMenuManager dropdownMenu = actionBars.getMenuManager();
        dropdownMenu.add((IAction)this.openNewCommitsAction);
        dropdownMenu.add((IAction)this.columnLayoutAction);
        dropdownMenu.add((IAction)this.fileNameModeAction);
        IUndoContext workspaceContext = (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class);
        this.undoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)this.getViewSite(), workspaceContext, true);
        this.undoRedoActionGroup.fillActionBars(actionBars);
    }

    private IBaseLabelProvider createLabelProvider(TableViewer tableViewer) {
        StagingViewLabelProvider baseProvider = new StagingViewLabelProvider();
        baseProvider.setFileNameMode(this.getPreferenceStore().getBoolean("StagingView_FileNameMode"));
        ProblemLabelDecorator decorator = new ProblemLabelDecorator((StructuredViewer)tableViewer);
        return new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)baseProvider, (ILabelDecorator)decorator, null);
    }

    private IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    private StagingViewLabelProvider getLabelProvider(ContentViewer viewer) {
        IBaseLabelProvider base = viewer.getLabelProvider();
        DelegatingStyledCellLabelProvider.IStyledLabelProvider styled = ((DelegatingStyledCellLabelProvider)base).getStyledStringProvider();
        return (StagingViewLabelProvider)styled;
    }

    private StagingViewContentProvider getContentProvider(ContentViewer viewer) {
        return (StagingViewContentProvider)viewer.getContentProvider();
    }

    private void updateSectionText() {
        Integer stagedCount = this.stagedTableViewer.getTable().getItemCount();
        this.stagedSection.setText(MessageFormat.format(UIText.StagingView_StagedChanges, stagedCount));
        Integer unstagedCount = this.unstagedTableViewer.getTable().getItemCount();
        this.unstagedSection.setText(MessageFormat.format(UIText.StagingView_UnstagedChanges, unstagedCount));
    }

    private void updateMessage() {
        String message = this.commitMessageComponent.getStatus().getMessage();
        boolean needsRedraw = false;
        if (message != null) {
            this.warningLabel.showMessage(message);
            needsRedraw = true;
        } else {
            needsRedraw = this.warningLabel.isVisible();
            this.warningLabel.hideMessage();
        }
        if (needsRedraw) {
            this.commitMessageSection.redraw();
        }
    }

    private void compareWith(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        StagingEntry stagingEntry = (StagingEntry)selection.getFirstElement();
        if (stagingEntry.isSubmodule()) {
            return;
        }
        switch (stagingEntry.getState()) {
            case ADDED: 
            case CHANGED: 
            case REMOVED: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareIndexWithHead", selection);
                break;
            }
            default: {
                CommonUtils.runCommand("org.eclipse.egit.ui.team.CompareWithIndex", selection);
            }
        }
    }

    private void createPopupMenu(final TableViewer tableViewer) {
        final MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Control control = tableViewer.getControl();
        control.setMenu(menuMgr.createContextMenu(control));
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection = (IStructuredSelection)tableViewer.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                boolean submoduleSelected = false;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (((StagingEntry)item).isSubmodule()) {
                        submoduleSelected = true;
                        break;
                    }
                    ++n2;
                }
                Action openWorkingTreeVersion = new Action(UIText.CommitFileDiffViewer_OpenWorkingTreeVersionInEditorMenuLabel){

                    public void run() {
                        StagingView.this.openSelectionInEditor(tableViewer.getSelection());
                    }
                };
                openWorkingTreeVersion.setEnabled(!submoduleSelected);
                menuMgr.add((IAction)openWorkingTreeVersion);
                Set availableActions = StagingView.getAvailableActions(selection);
                boolean addReplaceWithFileInGitIndex = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_FILE_IN_GIT_INDEX);
                boolean addReplaceWithHeadRevision = availableActions.contains((Object)StagingEntry.Action.REPLACE_WITH_HEAD_REVISION);
                boolean addStage = availableActions.contains((Object)StagingEntry.Action.STAGE);
                boolean addUnstage = availableActions.contains((Object)StagingEntry.Action.UNSTAGE);
                boolean addDelete = availableActions.contains((Object)StagingEntry.Action.DELETE);
                boolean addLaunchMergeTool = availableActions.contains((Object)StagingEntry.Action.LAUNCH_MERGE_TOOL);
                if (addStage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_StageItemMenuLabel){

                        public void run() {
                            StagingView.this.stage((IStructuredSelection)tableViewer.getSelection());
                        }
                    });
                }
                if (addUnstage) {
                    menuMgr.add((IAction)new Action(UIText.StagingView_UnstageItemMenuLabel){

                        public void run() {
                            StagingView.this.unstage((IStructuredSelection)tableViewer.getSelection());
                        }
                    });
                }
                boolean selectionIncludesNonWorkspaceResources = StagingView.this.selectionIncludesNonWorkspaceResources(tableViewer.getSelection());
                if (addReplaceWithFileInGitIndex) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithFileInGitIndex, selection, false));
                    } else {
                        menuMgr.add((IContributionItem)StagingView.this.createItem("org.eclipse.egit.ui.team.Discard", tableViewer));
                    }
                }
                if (addReplaceWithHeadRevision) {
                    if (selectionIncludesNonWorkspaceResources) {
                        menuMgr.add((IAction)new ReplaceAction(UIText.StagingView_replaceWithHeadRevision, selection, true));
                    } else {
                        menuMgr.add((IContributionItem)StagingView.this.createItem("org.eclipse.egit.ui.team.ReplaceWithHead", tableViewer));
                    }
                }
                if (addDelete) {
                    menuMgr.add((IAction)new DeleteAction(selection));
                }
                if (addLaunchMergeTool) {
                    menuMgr.add((IContributionItem)StagingView.this.createItem("org.eclipse.egit.ui.team.MergeTool", tableViewer));
                }
            }
        });
    }

    private void replaceWith(String[] files, boolean headRevision) {
        if (files == null || files.length == 0) {
            return;
        }
        CheckoutCommand checkoutCommand = new Git(this.currentRepository).checkout();
        if (headRevision) {
            checkoutCommand.setStartPoint("HEAD");
        }
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            checkoutCommand.addPath(path);
            ++n2;
        }
        try {
            checkoutCommand.call();
        }
        catch (Exception e) {
            Activator.handleError(UIText.StagingView_checkoutFailed, e, true);
        }
    }

    private String[] getSelectedFiles(IStructuredSelection selection) {
        ArrayList<String> result = new ArrayList<String>();
        for (StagingEntry stagingEntry : selection) {
            result.add(stagingEntry.getPath());
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean selectionIncludesNonWorkspaceResources(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object selectedObject : structuredSelection) {
            if (!(selectedObject instanceof StagingEntry)) {
                return false;
            }
            StagingEntry stagingEntry = (StagingEntry)selectedObject;
            String path = this.currentRepository.getWorkTree() + "/" + stagingEntry.getPath();
            if (this.getResource(path) != null) continue;
            return true;
        }
        return false;
    }

    private IFile getResource(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)new Path(path));
        if (file == null) {
            return null;
        }
        if (file.getProject().isAccessible()) {
            return file;
        }
        return null;
    }

    private void openSelectionInEditor(ISelection s) {
        if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iss = (IStructuredSelection)s;
        Iterator it = iss.iterator();
        while (it.hasNext()) {
            String relativePath = ((StagingEntry)it.next()).getPath();
            String path = new Path(this.currentRepository.getWorkTree().getAbsolutePath()).append(relativePath).toOSString();
            this.openFileInEditor(path);
        }
    }

    private void openFileInEditor(String filePath) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        File file = new File(filePath);
        if (!file.exists()) {
            String message = NLS.bind((String)UIText.CommitFileDiffViewer_FileDoesNotExist, (Object)filePath);
            Activator.showError(message, null);
        }
        IWorkbenchPage page = window.getActivePage();
        EgitUiEditorUtils.openEditor(file, page);
    }

    private static Set<StagingEntry.Action> getAvailableActions(IStructuredSelection selection) {
        EnumSet<StagingEntry.Action> availableActions = EnumSet.noneOf(StagingEntry.Action.class);
        for (StagingEntry stagingEntry : selection) {
            if (availableActions.isEmpty()) {
                availableActions.addAll(stagingEntry.getAvailableActions());
                continue;
            }
            availableActions.retainAll(stagingEntry.getAvailableActions());
        }
        return availableActions;
    }

    private CommandContributionItem createItem(String itemAction, TableViewer tableViewer) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        CommandContributionItemParameter itemParam = new CommandContributionItemParameter((IServiceLocator)workbench, null, itemAction, 8);
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IHandlerService hsr = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        ctx.addVariable("activeMenuSelection", (Object)tableViewer.getSelection());
        return new CommandContributionItem(itemParam);
    }

    private void reactOnSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            IResource adapted;
            StructuredSelection ssel = (StructuredSelection)selection;
            if (ssel.size() != 1) {
                return;
            }
            Object firstElement = ssel.getFirstElement();
            if (firstElement instanceof IResource) {
                this.showResource((IResource)firstElement);
            } else if (firstElement instanceof RepositoryTreeNode) {
                RepositoryTreeNode repoNode = (RepositoryTreeNode)firstElement;
                this.reload(repoNode.getRepository());
            } else if (firstElement instanceof IAdaptable && (adapted = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class)) != null) {
                this.showResource(adapted);
            }
        }
    }

    private void showResource(IResource resource) {
        IProject project = resource.getProject();
        RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)project);
        if (mapping == null) {
            return;
        }
        if (mapping.getRepository() != this.currentRepository) {
            this.reload(mapping.getRepository());
        }
    }

    private void stage(IStructuredSelection selection) {
        Git git = new Git(this.currentRepository);
        AddCommand add = null;
        RmCommand rm = null;
        for (StagingEntry entry : selection) {
            switch (entry.getState()) {
                case ADDED: 
                case CHANGED: 
                case REMOVED: {
                    break;
                }
                case MODIFIED: 
                case PARTIALLY_MODIFIED: 
                case UNTRACKED: 
                case CONFLICTING: {
                    if (add == null) {
                        add = git.add();
                    }
                    add.addFilepattern(entry.getPath());
                    break;
                }
                case MISSING: {
                    if (rm == null) {
                        rm = git.rm();
                    }
                    rm.addFilepattern(entry.getPath());
                }
            }
        }
        if (add != null) {
            try {
                add.call();
            }
            catch (NoFilepatternException noFilepatternException) {
            }
            catch (Exception e2) {
                Activator.error(e2.getMessage(), e2);
            }
        }
        if (rm != null) {
            try {
                rm.call();
            }
            catch (NoFilepatternException noFilepatternException) {
            }
            catch (Exception e2) {
                Activator.error(e2.getMessage(), e2);
            }
        }
    }

    private void unstage(IStructuredSelection selection) {
        DirCacheEditor edit;
        DirCache dirCache;
        if (selection.isEmpty()) {
            return;
        }
        RevCommit headRev = null;
        try {
            Ref head = this.currentRepository.getRef("HEAD");
            if (head.getObjectId() != null) {
                headRev = new RevWalk(this.currentRepository).parseCommit((AnyObjectId)head.getObjectId());
            }
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.CommitAction_MergeHeadErrorTitle, (String)UIText.CommitAction_ErrorReadingMergeMsg);
            return;
        }
        try {
            dirCache = this.currentRepository.lockDirCache();
            edit = dirCache.editor();
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.CommitAction_MergeHeadErrorTitle, (String)UIText.CommitAction_ErrorReadingMergeMsg);
            return;
        }
        try {
            this.updateDirCache(selection, headRev, edit);
            try {
                edit.commit();
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.CommitAction_MergeHeadErrorTitle, (String)UIText.CommitAction_ErrorReadingMergeMsg);
            }
        }
        finally {
            dirCache.unlock();
        }
    }

    private void updateDirCache(IStructuredSelection selection, RevCommit headRev, DirCacheEditor edit) {
        for (StagingEntry entry : selection) {
            switch (entry.getState()) {
                case ADDED: {
                    edit.add((DirCacheEditor.PathEdit)new DirCacheEditor.DeletePath(entry.getPath()));
                    break;
                }
                case CHANGED: 
                case REMOVED: {
                    try {
                        final TreeWalk tw = TreeWalk.forPath((Repository)this.currentRepository, (String)entry.getPath(), (RevTree)headRev.getTree());
                        if (tw == null) break;
                        edit.add(new DirCacheEditor.PathEdit(entry.getPath()){

                            public void apply(DirCacheEntry ent) {
                                ent.setFileMode(tw.getFileMode(0));
                                ent.setObjectId((AnyObjectId)tw.getObjectId(0));
                                ent.setLastModified(0L);
                            }
                        });
                        break;
                    }
                    catch (IOException iOException) {
                        MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.CommitAction_MergeHeadErrorTitle, (String)UIText.CommitAction_ErrorReadingMergeMsg);
                    }
                }
            }
        }
    }

    private boolean isValidRepo(Repository repository) {
        return repository != null && !repository.isBare() && repository.getWorkTree().exists() && org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil().contains(repository);
    }

    private void clearRepository() {
        this.saveCommitMessageComponentState();
        this.currentRepository = null;
        StagingViewUpdate update = new StagingViewUpdate(null, null, null);
        this.unstagedTableViewer.setInput((Object)update);
        this.stagedTableViewer.setInput((Object)update);
        this.enableCommitWidgets(false);
        this.updateSectionText();
        this.form.setText(UIText.StagingView_NoSelectionTitle);
    }

    private void reload(final Repository repository) {
        if (this.form.isDisposed()) {
            return;
        }
        if (repository == null) {
            this.asyncExec(new Runnable(){

                public void run() {
                    StagingView.this.clearRepository();
                }
            });
            return;
        }
        if (!this.isValidRepo(repository)) {
            return;
        }
        final boolean repositoryChanged = this.currentRepository != repository;
        this.asyncExec(new Runnable(){

            public void run() {
                if (StagingView.this.form.isDisposed()) {
                    return;
                }
                IndexDiffData indexDiff = StagingView.this.doReload(repository);
                boolean indexDiffAvailable = indexDiff != null;
                StagingViewUpdate update = new StagingViewUpdate(StagingView.this.currentRepository, indexDiff, null);
                StagingView.this.unstagedTableViewer.setInput((Object)update);
                StagingView.this.stagedTableViewer.setInput((Object)update);
                StagingView.this.enableCommitWidgets(indexDiffAvailable);
                StagingView.this.commitAction.setEnabled(indexDiffAvailable && repository.getRepositoryState().canCommit());
                StagingView.this.form.setText(StagingView.getRepositoryName(repository));
                StagingView.this.updateCommitMessageComponent(repositoryChanged, indexDiffAvailable);
                StagingView.this.updateSectionText();
            }
        });
    }

    private IndexDiffData doReload(Repository repository) {
        this.currentRepository = repository;
        IndexDiffCacheEntry entry = org.eclipse.egit.core.Activator.getDefault().getIndexDiffCache().getIndexDiffCacheEntry(this.currentRepository);
        if (this.cacheEntry != null && this.cacheEntry != entry) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        this.cacheEntry = entry;
        this.cacheEntry.addIndexDiffChangedListener(this.myIndexDiffListener);
        return this.cacheEntry.getIndexDiff();
    }

    private void clearCommitMessageToggles() {
        this.amendPreviousCommitAction.setChecked(false);
        this.addChangeIdAction.setChecked(false);
        this.signedOffByAction.setChecked(false);
    }

    void updateCommitMessageComponent(boolean repositoryChanged, boolean indexDiffAvailable) {
        CommitHelper helper = new CommitHelper(this.currentRepository);
        CommitMessageComponentState oldState = null;
        if (repositoryChanged) {
            if (this.userEnteredCommmitMessage()) {
                this.saveCommitMessageComponentState();
            } else {
                this.deleteCommitMessageComponentState();
            }
            oldState = this.loadCommitMessageComponentState();
            this.commitMessageComponent.setRepository(this.currentRepository);
            if (oldState == null) {
                this.loadInitialState(helper);
            } else {
                this.loadExistingState(helper, oldState);
            }
        } else if (this.userEnteredCommmitMessage()) {
            if (!this.commitMessageComponent.getHeadCommit().equals((AnyObjectId)helper.getPreviousCommit())) {
                this.addHeadChangedWarning(this.commitMessageComponent.getCommitMessage());
            }
        } else {
            this.loadInitialState(helper);
        }
        this.amendPreviousCommitAction.setChecked(this.commitMessageComponent.isAmending());
        this.amendPreviousCommitAction.setEnabled(indexDiffAvailable && helper.amendAllowed());
        this.updateMessage();
    }

    private void loadExistingState(CommitHelper helper, CommitMessageComponentState oldState) {
        boolean headCommitChanged = !oldState.getHeadCommit().equals((AnyObjectId)this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.enableListers(false);
        this.commitMessageComponent.setAuthor(oldState.getAuthor());
        if (headCommitChanged) {
            this.addHeadChangedWarning(oldState.getCommitMessage());
        } else {
            this.commitMessageComponent.setCommitMessage(oldState.getCommitMessage());
        }
        this.commitMessageComponent.setCommitter(oldState.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        boolean amendAllowed = helper.amendAllowed();
        this.commitMessageComponent.setAmendAllowed(amendAllowed);
        if (!amendAllowed) {
            this.commitMessageComponent.setAmending(false);
        } else if (!headCommitChanged && oldState.getAmend()) {
            this.commitMessageComponent.setAmending(true);
        } else {
            this.commitMessageComponent.setAmending(false);
        }
        this.commitMessageComponent.updateUIFromState();
        this.commitMessageComponent.updateSignedOffAndChangeIdButton();
        this.commitMessageComponent.enableListers(true);
    }

    private void addHeadChangedWarning(String commitMessage) {
        String message = String.valueOf(UIText.StagingView_headCommitChanged) + Text.DELIMITER + Text.DELIMITER + commitMessage;
        this.commitMessageComponent.setCommitMessage(message);
    }

    private void loadInitialState(CommitHelper helper) {
        this.commitMessageComponent.enableListers(false);
        this.commitMessageComponent.resetState();
        this.commitMessageComponent.setAuthor(helper.getAuthor());
        this.commitMessageComponent.setCommitMessage(helper.getCommitMessage());
        this.commitMessageComponent.setCommitter(helper.getCommitter());
        this.commitMessageComponent.setHeadCommit(this.getCommitId(helper.getPreviousCommit()));
        this.commitMessageComponent.setCommitAllowed(helper.canCommit());
        this.commitMessageComponent.setCannotCommitMessage(helper.getCannotCommitMessage());
        this.commitMessageComponent.setAmendAllowed(helper.amendAllowed());
        this.commitMessageComponent.setAmending(false);
        this.commitMessageComponent.setDefaults();
        this.commitMessageComponent.updateUI();
        this.commitMessageComponent.enableListers(true);
    }

    private boolean userEnteredCommmitMessage() {
        if (this.commitMessageComponent.getRepository() == null) {
            return false;
        }
        String message = this.commitMessageComponent.getCommitMessage().replace(UIText.StagingView_headCommitChanged, EMPTY_STRING);
        if (message == null || message.trim().length() == 0) {
            return false;
        }
        String chIdLine = "Change-Id: I" + ObjectId.zeroId().name();
        if (this.currentRepository.getConfig().getBoolean("gerrit", "createchangeid", false) && this.commitMessageComponent.getCreateChangeId()) {
            if (message.trim().equals(chIdLine)) {
                return false;
            }
            message = message.replace(chIdLine, EMPTY_STRING);
        }
        return !Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_signed_off_by") || !this.commitMessageComponent.isSignedOff() || !message.trim().equals("Signed-off-by: " + this.commitMessageComponent.getCommitter());
    }

    private ObjectId getCommitId(RevCommit commit) {
        if (commit == null) {
            return ObjectId.zeroId();
        }
        return commit.getId();
    }

    private void saveCommitMessageComponentState() {
        Repository repo = this.commitMessageComponent.getRepository();
        if (repo != null) {
            CommitMessageComponentStateManager.persistState(repo, this.commitMessageComponent.getState());
        }
    }

    private void deleteCommitMessageComponentState() {
        if (this.commitMessageComponent.getRepository() != null) {
            CommitMessageComponentStateManager.deleteState(this.commitMessageComponent.getRepository());
        }
    }

    private CommitMessageComponentState loadCommitMessageComponentState() {
        return CommitMessageComponentStateManager.loadState(this.currentRepository);
    }

    private static String getRepositoryName(Repository repository) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        RepositoryState state = repository.getRepositoryState();
        if (state != RepositoryState.SAFE) {
            return String.valueOf(repoName) + '|' + state.getDescription();
        }
        return repoName;
    }

    private Collection<String> getStagedFileNames() {
        StagingViewContentProvider stagedContentProvider = this.getContentProvider((ContentViewer)this.stagedTableViewer);
        StagingEntry[] entries = stagedContentProvider.getStagingEntries();
        ArrayList<String> files = new ArrayList<String>();
        StagingEntry[] stagingEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            StagingEntry entry = stagingEntryArray[n2];
            files.add(entry.getPath());
            ++n2;
        }
        return files;
    }

    private void commit() {
        if (!this.isCommitWithoutFilesAllowed()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)UIText.StagingView_committingNotPossible, (String)UIText.StagingView_noStagedFiles);
            return;
        }
        if (!this.commitMessageComponent.checkCommitInfo()) {
            return;
        }
        if (!UIUtils.saveAllEditors(this.currentRepository)) {
            return;
        }
        String commitMessage = this.commitMessageComponent.getCommitMessage();
        CommitOperation commitOperation = null;
        try {
            commitOperation = new CommitOperation(this.currentRepository, this.commitMessageComponent.getAuthor(), this.commitMessageComponent.getCommitter(), commitMessage);
        }
        catch (CoreException e) {
            Activator.handleError(UIText.StagingView_commitFailed, e, true);
            return;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            commitOperation.setAmending(true);
        }
        commitOperation.setComputeChangeId(this.addChangeIdAction.isChecked());
        CommitUI.performCommit(this.currentRepository, commitOperation, this.openNewCommitsAction.isChecked());
        CommitMessageHistory.saveCommitHistory(commitMessage);
        this.clearCommitMessageToggles();
        this.commitMessageText.setText(EMPTY_STRING);
    }

    private boolean isCommitWithoutFilesAllowed() {
        if (this.stagedTableViewer.getTable().getItemCount() > 0) {
            return true;
        }
        if (this.amendPreviousCommitAction.isChecked()) {
            return true;
        }
        return CommitHelper.isCommitWithoutFilesAllowed(this.currentRepository);
    }

    public void setFocus() {
        this.unstagedTableViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        ISelectionService srv = (ISelectionService)this.getSite().getService(ISelectionService.class);
        srv.removePostSelectionListener(this.selectionChangedListener);
        if (this.cacheEntry != null) {
            this.cacheEntry.removeIndexDiffChangedListener(this.myIndexDiffListener);
        }
        if (this.undoRedoActionGroup != null) {
            this.undoRedoActionGroup.dispose();
        }
        new InstanceScope().getNode(org.eclipse.egit.core.Activator.getPluginId()).removePreferenceChangeListener(this.prefListener);
    }

    private void asyncExec(Runnable runnable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeleteAction
    extends Action {
        private final IStructuredSelection selection;

        DeleteAction(IStructuredSelection selection) {
            super(UIText.StagingView_DeleteItemMenuLabel);
            this.selection = selection;
        }

        public void run() {
            DeletePathsOperationUI operation = new DeletePathsOperationUI(this.getSelectedPaths(), (IShellProvider)StagingView.this.getSite());
            operation.run();
        }

        private List<IPath> getSelectedPaths() {
            ArrayList<IPath> paths = new ArrayList<IPath>();
            for (StagingEntry stagingEntry : this.selection) {
                paths.add(stagingEntry.getLocation());
            }
            return paths;
        }
    }

    private class ReplaceAction
    extends Action {
        IStructuredSelection selection;
        private final boolean headRevision;

        ReplaceAction(String text, IStructuredSelection selection, boolean headRevision) {
            super(text);
            this.selection = selection;
            this.headRevision = headRevision;
        }

        public void run() {
            boolean performAction = MessageDialog.openConfirm((Shell)StagingView.this.form.getShell(), (String)UIText.DiscardChangesAction_confirmActionTitle, (String)UIText.DiscardChangesAction_confirmActionMessage);
            if (!performAction) {
                return;
            }
            String[] files = StagingView.this.getSelectedFiles(this.selection);
            StagingView.this.replaceWith(files, this.headRevision);
        }
    }

    static class StagingDragListener
    extends DragSourceAdapter {
        private ISelectionProvider provider;

        public StagingDragListener(ISelectionProvider provider) {
            this.provider = provider;
        }

        public void dragStart(DragSourceEvent event) {
            event.doit = !this.provider.getSelection().isEmpty();
        }

        public void dragFinished(DragSourceEvent event) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
            }
        }

        public void dragSetData(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.provider.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                return;
            }
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                ArrayList<String> files = new ArrayList<String>();
                for (Object selected : selection.toList()) {
                    StagingEntry entry;
                    File file;
                    if (!(selected instanceof StagingEntry) || !(file = new File((entry = (StagingEntry)selected).getRepository().getWorkTree(), entry.getPath())).exists()) continue;
                    files.add(file.getAbsolutePath());
                }
                if (!files.isEmpty()) {
                    event.data = files.toArray(new String[files.size()]);
                    return;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StagingViewUpdate {
        Repository repository;
        IndexDiffData indexDiff;
        Collection<String> changedResources;

        StagingViewUpdate(Repository theRepository, IndexDiffData theIndexDiff, Collection<String> theChanges) {
            this.repository = theRepository;
            this.indexDiff = theIndexDiff;
            this.changedResources = theChanges;
        }
    }
}

