/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.token;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;
import org.eclipse.mylyn.wikitext.mediawiki.core.MediaWikiLanguage;

public class ImageReplacementToken
extends PatternBasedElement {
    private static Pattern widthHeightPart = Pattern.compile("(\\d+)(x(\\d+))?px");
    private static Pattern altPattern = Pattern.compile("\\s*alt\\s*=\\s*(.+)");

    protected String getPattern(int groupOffset) {
        return "(?:\\[\\[Image:\\s*([^\\]\\|]+)(?:\\|(([^\\[\\]]|(\\[\\[[^\\[\\]]+\\]\\]))*))?\\]\\])";
    }

    protected int getPatternGroupCount() {
        return 4;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ImageReplacementTokenProcessor();
    }

    private static class ImageReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ImageReplacementTokenProcessor() {
        }

        public MediaWikiLanguage getMarkupLanguage() {
            return (MediaWikiLanguage)super.getMarkupLanguage();
        }

        public void emit() {
            String imageUrl = this.group(1);
            if (imageUrl.indexOf(47) == -1) {
                imageUrl = imageUrl.replace(' ', '_');
            }
            imageUrl = this.getMarkupLanguage().mapImageName(imageUrl);
            String optionsString = this.group(2);
            boolean thumbnail = false;
            ImageAttributes attributes = new ImageAttributes();
            if (optionsString != null) {
                String[] options = optionsString.split("\\s*\\|\\s*");
                int optionIndex = 0;
                while (optionIndex < options.length) {
                    String option = options[optionIndex];
                    if ("center".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Middle);
                    } else if ("left".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Left);
                    } else if ("right".equals(option)) {
                        attributes.setAlign(ImageAttributes.Align.Right);
                    } else if ("none".equals(option)) {
                        attributes.setAlign(null);
                    } else if ("thumb".equals(option) || "thumbnail".equals(option)) {
                        thumbnail = true;
                    } else {
                        Matcher matcher = widthHeightPart.matcher(option);
                        if (matcher.matches()) {
                            try {
                                String sizePart = matcher.group(1);
                                String heightPart = matcher.group(3);
                                int size = Integer.parseInt(sizePart);
                                attributes.setWidth(size);
                                if (heightPart != null) {
                                    int height = Integer.parseInt(heightPart);
                                    attributes.setHeight(height);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if ("frameless".equals(option)) {
                            attributes.setBorder(0);
                        } else if ("frame".equals(option)) {
                            attributes.setBorder(1);
                        } else {
                            Matcher altMatcher = altPattern.matcher(option);
                            if (altMatcher.matches()) {
                                attributes.setAlt(altMatcher.group(1));
                            } else if (optionIndex == options.length - 1) {
                                attributes.setTitle(option);
                            } else {
                                attributes.setAlt(option);
                            }
                        }
                    }
                    ++optionIndex;
                }
            }
            if (thumbnail) {
                String caption = attributes.getTitle();
                attributes.setTitle(null);
                Attributes outerDivAttributes = new Attributes(null, "thumb", null, null);
                if (attributes.getAlign() != null) {
                    outerDivAttributes.appendCssClass(attributes.getAlign().name().toLowerCase());
                }
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, outerDivAttributes);
                Attributes thumbInnerDivAttributes = new Attributes(null, "thumbinner", attributes.getWidth() > 0 ? String.format("width:%spx;", attributes.getWidth() + 2) : null, null);
                this.builder.beginBlock(DocumentBuilder.BlockType.DIV, thumbInnerDivAttributes);
                LinkAttributes linkAttributes = new LinkAttributes();
                linkAttributes.setCssClass("image");
                attributes.appendCssClass("thumbimage");
                this.builder.imageLink((Attributes)linkAttributes, (Attributes)attributes, imageUrl, imageUrl);
                if (caption != null) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes(null, "thumbcaption", null, null));
                    this.markupLanguage.emitMarkupText(this.parser, this.state, caption);
                    this.builder.endBlock();
                }
                this.builder.endBlock();
                this.builder.endBlock();
            } else {
                this.builder.image((Attributes)attributes, imageUrl);
            }
        }
    }
}

