/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TimeGraphTooltipHandler {
    private Shell _tipShell;
    private Table _tipTable;
    private Point _tipPosition;
    private final ITimeDataProvider _timeDataProvider;
    ITimeGraphPresentationProvider _utilImp = null;

    public TimeGraphTooltipHandler(Shell parent, ITimeGraphPresentationProvider rUtilImpl, ITimeDataProvider timeProv) {
        this._utilImp = rUtilImpl;
        this._timeDataProvider = timeProv;
    }

    private void createTooltipShell(Shell parent) {
        Display display = parent.getDisplay();
        if (this._tipShell != null && !this._tipShell.isDisposed()) {
            this._tipShell.dispose();
        }
        this._tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this._tipShell.setLayout((Layout)gridLayout);
        this._tipShell.setBackground(display.getSystemColor(29));
        this._tipTable = new Table((Composite)this._tipShell, 0);
        new TableColumn(this._tipTable, 0);
        new TableColumn(this._tipTable, 0);
        this._tipTable.setForeground(display.getSystemColor(28));
        this._tipTable.setBackground(display.getSystemColor(29));
        this._tipTable.setHeaderVisible(false);
        this._tipTable.setLinesVisible(false);
        this._tipTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TimeGraphTooltipHandler.this._tipShell.dispose();
            }
        });
        this._tipTable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                TimeGraphTooltipHandler.this._tipShell.dispose();
            }
        });
        this._tipTable.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                TimeGraphTooltipHandler.this._tipShell.dispose();
            }
        });
    }

    public void activateHoverHelp(final Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (TimeGraphTooltipHandler.this._tipShell != null && !TimeGraphTooltipHandler.this._tipShell.isDisposed()) {
                    TimeGraphTooltipHandler.this._tipShell.dispose();
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (TimeGraphTooltipHandler.this._tipShell != null && !TimeGraphTooltipHandler.this._tipShell.isDisposed()) {
                    TimeGraphTooltipHandler.this._tipShell.dispose();
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (TimeGraphTooltipHandler.this._tipShell != null && !TimeGraphTooltipHandler.this._tipShell.isDisposed()) {
                    Point pt = control.toDisplay(e.x, e.y);
                    if (!TimeGraphTooltipHandler.this._tipShell.getBounds().contains(pt)) {
                        TimeGraphTooltipHandler.this._tipShell.dispose();
                    }
                }
            }

            private void addItem(String name, String value) {
                TableItem line = new TableItem(TimeGraphTooltipHandler.this._tipTable, 0);
                line.setText(0, name);
                line.setText(1, value);
            }

            private void fillValues(Point pt, TimeGraphControl timeGraphControl, ITimeGraphEntry entry) {
                if (entry == null) {
                    return;
                }
                if (entry.hasTimeEvents()) {
                    Map<String, String> eventAddOns;
                    long currPixelTime = timeGraphControl.getTimeAtX(pt.x);
                    long nextPixelTime = timeGraphControl.getTimeAtX(pt.x + 1);
                    if (nextPixelTime == currPixelTime) {
                        ++nextPixelTime;
                    }
                    ITimeEvent currEvent = Utils.findEvent(entry, currPixelTime, 0);
                    ITimeEvent nextEvent = Utils.findEvent(entry, currPixelTime, 1);
                    if ((currEvent == null || currEvent.getTime() < currPixelTime) && nextEvent != null && nextEvent.getTime() < nextPixelTime) {
                        currEvent = nextEvent;
                    }
                    this.addItem(TimeGraphTooltipHandler.this._utilImp.getStateTypeName(), entry.getName());
                    if (currEvent == null) {
                        return;
                    }
                    String state = TimeGraphTooltipHandler.this._utilImp.getEventName(currEvent);
                    if (state != null) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STATE, state);
                    }
                    if ((eventAddOns = TimeGraphTooltipHandler.this._utilImp.getEventHoverToolTipInfo(currEvent)) != null) {
                        for (String message : eventAddOns.keySet()) {
                            this.addItem(message, eventAddOns.get(message));
                        }
                    }
                    long eventStartTime = -1L;
                    long eventDuration = -1L;
                    long eventEndTime = -1L;
                    eventStartTime = currEvent.getTime();
                    eventDuration = currEvent.getDuration();
                    if (eventDuration < 0L && nextEvent != null) {
                        eventEndTime = nextEvent.getTime();
                        eventDuration = eventEndTime - eventStartTime;
                    } else {
                        eventEndTime = eventStartTime + eventDuration;
                    }
                    Utils.Resolution res = Utils.Resolution.NANOSEC;
                    if (TimeGraphTooltipHandler.this._timeDataProvider.isCalendarFormat()) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_DATE, eventStartTime > -1L ? Utils.formatDate(eventStartTime) : "?");
                        if (eventDuration > 0L) {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.ABSOLUTE, res) : "?");
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, Utils.TimeFormat.ABSOLUTE, res) : "?");
                        } else {
                            this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.ABSOLUTE, res) : "?");
                        }
                    } else if (eventDuration > 0L) {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_START_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.RELATIVE, res) : "?");
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_STOP_TIME, eventEndTime > -1L ? Utils.formatTime(eventEndTime, Utils.TimeFormat.RELATIVE, res) : "?");
                    } else {
                        this.addItem(Messages.TmfTimeTipHandler_TRACE_EVENT_TIME, eventStartTime > -1L ? Utils.formatTime(eventStartTime, Utils.TimeFormat.RELATIVE, res) : "?");
                    }
                    if (eventDuration > 0L) {
                        this.addItem(Messages.TmfTimeTipHandler_DURATION, eventDuration > -1L ? Utils.formatTime(eventDuration, Utils.TimeFormat.RELATIVE, res) : "?");
                    }
                }
            }

            public void mouseHover(MouseEvent event) {
                Point pt = new Point(event.x, event.y);
                TimeGraphControl timeGraphControl = (TimeGraphControl)event.widget;
                TimeGraphTooltipHandler.this.createTooltipShell(timeGraphControl.getShell());
                ITimeGraphEntry entry = timeGraphControl.getEntry(pt);
                TimeGraphTooltipHandler.this._tipTable.remove(0, TimeGraphTooltipHandler.this._tipTable.getItemCount() - 1);
                this.fillValues(pt, timeGraphControl, entry);
                if (TimeGraphTooltipHandler.this._tipTable.getItemCount() == 0) {
                    return;
                }
                TimeGraphTooltipHandler.this._tipTable.getColumn(0).pack();
                TimeGraphTooltipHandler.this._tipTable.getColumn(1).pack();
                TimeGraphTooltipHandler.this._tipShell.pack();
                TimeGraphTooltipHandler.this._tipPosition = control.toDisplay(pt);
                TimeGraphTooltipHandler.this._tipShell.pack();
                TimeGraphTooltipHandler.setHoverLocation(TimeGraphTooltipHandler.this._tipShell, TimeGraphTooltipHandler.this._tipPosition);
                TimeGraphTooltipHandler.this._tipShell.setVisible(true);
            }
        });
    }

    private static void setHoverLocation(Shell shell, Point position) {
        Rectangle displayBounds = shell.getDisplay().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shellBounds.x = position.x + shellBounds.width + 16 > displayBounds.width && position.x - shellBounds.width - 16 >= 0 ? position.x - shellBounds.width - 16 : Math.max(Math.min(position.x + 16, displayBounds.width - shellBounds.width), 0);
        shellBounds.y = position.y + shellBounds.height + 16 > displayBounds.height && position.y - shellBounds.height - 16 >= 0 ? position.y - shellBounds.height - 16 : Math.max(Math.min(position.y + 16, displayBounds.height - shellBounds.height), 0);
        shell.setBounds(shellBounds);
    }
}

