/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class TimeGraphLegend
extends TitleAreaDialog {
    private final ITimeGraphPresentationProvider provider;
    private final LocalResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static void open(Shell parent, ITimeGraphPresentationProvider provider) {
        new TimeGraphLegend(parent, provider).open();
    }

    public TimeGraphLegend(Shell parent, ITimeGraphPresentationProvider provider) {
        super(parent);
        this.provider = provider;
        this.setShellStyle(this.getShellStyle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite dlgArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dlgArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.createStatesGroup(composite);
        this.setTitle(Messages.TmfTimeLegend_LEGEND);
        TimeGraphLegend.setDialogHelpAvailable((boolean)false);
        this.setHelpAvailable(false);
        return composite;
    }

    private void createStatesGroup(Composite composite) {
        Group gs = new Group(composite, 0);
        gs.setText(String.valueOf(this.provider.getStateTypeName()) + " " + Messages.TmfTimeLegend_StateTypeName);
        GridData gd = new GridData(4, 4, true, true);
        gs.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 20;
        layout.marginBottom = 10;
        gs.setLayout((Layout)layout);
        StateItem[] stateItems = this.provider.getStateTable();
        int i = 0;
        while (i < stateItems.length) {
            RGB rgb = stateItems[i].getStateColor();
            String stateName = stateItems[i].getStateString();
            Bar bar = new Bar((Composite)gs, rgb);
            gd = new GridData();
            gd.widthHint = 40;
            gd.heightHint = 20;
            gd.verticalIndent = 8;
            bar.setLayoutData(gd);
            Label name = new Label((Composite)gs, 0);
            name.setText(stateName);
            gd = new GridData();
            gd.horizontalIndent = 10;
            gd.verticalIndent = 8;
            name.setLayoutData((Object)gd);
            ++i;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.TmfTimeLegend_TRACE_STATES_TITLE);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    class Bar
    extends Canvas {
        private final Color color;

        public Bar(Composite parent, RGB rgb) {
            super(parent, 0);
            this.color = TimeGraphLegend.this.fResourceManager.createColor(rgb);
            this.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Bar.this.draw(event.gc);
                }
            });
        }

        private void draw(GC gc) {
            Rectangle r = this.getClientArea();
            gc.setBackground(this.color);
            gc.fillRectangle(r);
            gc.setForeground(Display.getDefault().getSystemColor(2));
            gc.drawRectangle(0, 0, r.width - 1, r.height - 1);
        }

        public void dispose() {
            super.dispose();
            this.color.dispose();
        }
    }
}

