/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTrace;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.linuxtools.tmf.core.TmfCommonConstants;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TmfTraceElement
extends TmfProjectModelElement
implements IActionFilter,
IPropertySource2 {
    public static final String BUNDLE = "bundle";
    public static final String IS_LINKED = "isLinked";
    private static final String sfInfoCategory = "Info";
    private static final String sfName = "name";
    private static final String sfPath = "path";
    private static final String sfLocation = "location";
    private static final String sfEventType = "type";
    private static final String sfIsLinked = "linked";
    private static final TextPropertyDescriptor sfNameDescriptor = new TextPropertyDescriptor((Object)"name", "name");
    private static final TextPropertyDescriptor sfPathDescriptor = new TextPropertyDescriptor((Object)"path", "path");
    private static final TextPropertyDescriptor sfLocationDescriptor = new TextPropertyDescriptor((Object)"location", "location");
    private static final TextPropertyDescriptor sfTypeDescriptor = new TextPropertyDescriptor((Object)"type", "type");
    private static final TextPropertyDescriptor sfIsLinkedDescriptor = new TextPropertyDescriptor((Object)"linked", "linked");
    private static final IPropertyDescriptor[] sfDescriptors = new IPropertyDescriptor[]{sfNameDescriptor, sfPathDescriptor, sfLocationDescriptor, sfTypeDescriptor, sfIsLinkedDescriptor};
    private String fTraceTypeId = null;
    private static final Map<String, IConfigurationElement> sfTraceTypeAttributes;
    private static final Map<String, IConfigurationElement> sfTraceCategories;

    static {
        sfNameDescriptor.setCategory(sfInfoCategory);
        sfPathDescriptor.setCategory(sfInfoCategory);
        sfLocationDescriptor.setCategory(sfInfoCategory);
        sfTypeDescriptor.setCategory(sfInfoCategory);
        sfIsLinkedDescriptor.setCategory(sfInfoCategory);
        sfTraceTypeAttributes = new HashMap<String, IConfigurationElement>();
        sfTraceCategories = new HashMap<String, IConfigurationElement>();
    }

    public static void init() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.linuxtools.tmf.ui.tracetype");
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String elementName = ce.getName();
            if (elementName.equals(sfEventType)) {
                String traceTypeId = ce.getAttribute("id");
                sfTraceTypeAttributes.put(traceTypeId, ce);
            } else if (elementName.equals("category")) {
                String categoryId = ce.getAttribute("id");
                sfTraceCategories.put(categoryId, ce);
            }
            ++n2;
        }
    }

    public TmfTraceElement(String name, IResource trace, TmfTraceFolder parent) {
        this(name, trace, (TmfProjectModelElement)parent);
    }

    public TmfTraceElement(String name, IResource trace, TmfExperimentElement parent) {
        this(name, trace, (TmfProjectModelElement)parent);
    }

    private TmfTraceElement(String name, IResource trace, TmfProjectModelElement parent) {
        super(name, trace, parent);
        parent.addChild(this);
        this.refreshTraceType();
    }

    public String getTraceType() {
        return this.fTraceTypeId;
    }

    public void refreshTraceType() {
        try {
            this.fTraceTypeId = this.getResource().getPersistentProperty(TmfCommonConstants.TRACETYPE);
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error refreshing trace type pesistent property for trace " + this.getName(), e);
        }
    }

    public ITmfTrace<?> instantiateTrace() {
        try {
            this.refreshSupplementaryFolder();
            if (this.fTraceTypeId != null) {
                CustomTraceDefinition def;
                int n;
                int n2;
                CustomTraceDefinition[] customTraceDefinitionArray;
                if (this.fTraceTypeId.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + ((CustomTxtTraceDefinition)def).definitionName)) {
                            return new CustomTxtTrace((CustomTxtTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if (this.fTraceTypeId.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + ((CustomXmlTraceDefinition)def).definitionName)) {
                            return new CustomXmlTrace((CustomXmlTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
                ITmfTrace trace = (ITmfTrace)ce.createExecutableExtension("trace_type");
                return trace;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error instantiating ITmfTrace object for trace " + this.getName(), e);
        }
        return null;
    }

    public ITmfEvent instantiateEvent() {
        try {
            if (this.fTraceTypeId != null) {
                CustomTraceDefinition def;
                int n;
                int n2;
                CustomTraceDefinition[] customTraceDefinitionArray;
                if (this.fTraceTypeId.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomTxtTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomTxtTrace.class.getCanonicalName()) + ":" + ((CustomTxtTraceDefinition)def).definitionName)) {
                            return new CustomTxtEvent((CustomTxtTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                if (this.fTraceTypeId.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                    customTraceDefinitionArray = CustomXmlTraceDefinition.loadAll();
                    n2 = customTraceDefinitionArray.length;
                    n = 0;
                    while (n < n2) {
                        def = customTraceDefinitionArray[n];
                        if (this.fTraceTypeId.equals(String.valueOf(CustomXmlTrace.class.getCanonicalName()) + ":" + ((CustomXmlTraceDefinition)def).definitionName)) {
                            return new CustomXmlEvent((CustomXmlTraceDefinition)def);
                        }
                        ++n;
                    }
                }
                IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
                ITmfEvent event = (ITmfEvent)ce.createExecutableExtension("event_type");
                return event;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error instantiating ITmfEvent object for trace " + this.getName(), e);
        }
        return null;
    }

    public String getEditorId() {
        if (this.fTraceTypeId != null) {
            if (this.fTraceTypeId.startsWith(CustomTxtTrace.class.getCanonicalName())) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            if (this.fTraceTypeId.startsWith(CustomXmlTrace.class.getCanonicalName())) {
                return "org.eclipse.linuxtools.tmf.ui.editors.events";
            }
            IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
            IConfigurationElement[] defaultEditorCE = ce.getChildren("defaultEditor");
            if (defaultEditorCE.length == 1) {
                return defaultEditorCE[0].getAttribute("id");
            }
        }
        return null;
    }

    public TmfTraceElement getElementUnderTraceFolder() {
        if (this.getParent() instanceof TmfExperimentElement) {
            for (TmfTraceElement aTrace : this.getProject().getTracesFolder().getTraces()) {
                if (!aTrace.getName().equals(this.getName())) continue;
                return aTrace;
            }
        }
        return this;
    }

    public void deleteSupplementaryFolder() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.fResource.getName());
        if (supplFolder.exists()) {
            try {
                supplFolder.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
            }
        }
    }

    public void renameSupplementaryFolder(String newTraceName) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.fResource.getName());
        IFolder newSupplFolder = this.getTraceSupplementaryFolder(newTraceName);
        if (oldSupplFolder.exists()) {
            try {
                oldSupplFolder.move(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void copySupplementaryFolder(String newTraceName) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.fResource.getName());
        IFolder newSupplFolder = this.getTraceSupplementaryFolder(newTraceName);
        if (oldSupplFolder.exists()) {
            try {
                oldSupplFolder.copy(newSupplFolder.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error renaming supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void copySupplementaryFolder(IFolder destination) {
        IFolder oldSupplFolder = this.getTraceSupplementaryFolder(this.fResource.getName());
        if (oldSupplFolder.exists()) {
            try {
                oldSupplFolder.copy(destination.getFullPath(), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error copying supplementary folder " + oldSupplFolder, e);
            }
        }
    }

    public void refreshSupplementaryFolder() {
        this.createSupplementaryDirectory();
    }

    public boolean hasSupplementaryResources() {
        IResource[] resources = this.getSupplementaryResources();
        return resources.length > 0;
    }

    public IResource[] getSupplementaryResources() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.fResource.getName());
        if (supplFolder.exists()) {
            try {
                return supplFolder.members();
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary folder " + supplFolder, e);
            }
        }
        return new IResource[0];
    }

    public void deleteSupplementaryResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            try {
                resources[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting supplementary resource " + resources[i], e);
            }
            ++i;
        }
    }

    private void createSupplementaryDirectory() {
        IFolder supplFolder = this.getTraceSupplementaryFolder(this.fResource.getName());
        if (!supplFolder.exists()) {
            try {
                supplFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error creating resource supplementary file " + supplFolder, e);
            }
        }
        try {
            this.fResource.setPersistentProperty(TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, supplFolder.getLocationURI().getPath());
        }
        catch (CoreException e) {
            Activator.getDefault().logError("Error setting persistant property " + TmfCommonConstants.TRACE_SUPPLEMENTARY_FOLDER, e);
        }
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(IS_LINKED)) {
            boolean isLinked = this.getResource().isLinked();
            return Boolean.toString(isLinked).equals(value);
        }
        return false;
    }

    @Override
    public TmfProjectElement getProject() {
        if (this.getParent() instanceof TmfTraceFolder) {
            TmfTraceFolder folder = (TmfTraceFolder)this.getParent();
            TmfProjectElement project = (TmfProjectElement)folder.getParent();
            return project;
        }
        if (this.getParent() instanceof TmfExperimentElement) {
            TmfExperimentElement experiment = (TmfExperimentElement)this.getParent();
            TmfExperimentFolder folder = (TmfExperimentFolder)experiment.getParent();
            TmfProjectElement project = (TmfProjectElement)folder.getParent();
            return project;
        }
        return null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return sfDescriptors != null ? Arrays.copyOf(sfDescriptors, sfDescriptors.length) : null;
    }

    public Object getPropertyValue(Object id) {
        if (sfName.equals(id)) {
            return this.getName();
        }
        if (sfPath.equals(id)) {
            return this.getPath().toString();
        }
        if (sfLocation.equals(id)) {
            return this.getLocation().toString();
        }
        if (sfIsLinked.equals(id)) {
            return Boolean.valueOf(this.getResource().isLinked()).toString();
        }
        if (sfEventType.equals(id) && this.fTraceTypeId != null) {
            IConfigurationElement ce = sfTraceTypeAttributes.get(this.fTraceTypeId);
            return ce != null ? String.valueOf(TmfTraceElement.getCategory(ce)) + " : " + ce.getAttribute(sfName) : "";
        }
        return null;
    }

    private static String getCategory(IConfigurationElement ce) {
        IConfigurationElement category;
        String categoryId = ce.getAttribute("category");
        if (categoryId != null && (category = sfTraceCategories.get(categoryId)) != null) {
            return category.getAttribute(sfName);
        }
        return "[no category]";
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

