/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class TmfNavigatorContentProvider
implements IPipelinedTreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.isAccessible();
        }
        if (element instanceof TmfTraceFolder) {
            TmfTraceFolder folder = (TmfTraceFolder)element;
            return folder.hasChildren();
        }
        if (element instanceof TmfExperimentFolder) {
            TmfExperimentFolder folder = (TmfExperimentFolder)element;
            return folder.hasChildren();
        }
        if (element instanceof TmfExperimentElement) {
            TmfExperimentElement folder = (TmfExperimentElement)element;
            return folder.hasChildren();
        }
        return false;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public synchronized Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            return this.getProjectChildren((IProject)parentElement);
        }
        if (parentElement instanceof TmfTraceFolder) {
            return this.getTraceFolderChildren((TmfTraceFolder)parentElement);
        }
        if (parentElement instanceof TmfExperimentFolder) {
            return this.getExperimentFolderChildren((TmfExperimentFolder)parentElement);
        }
        if (parentElement instanceof TmfExperimentElement) {
            return this.getExperimentChildren((TmfExperimentElement)parentElement);
        }
        return new Object[0];
    }

    private Object[] getProjectChildren(IProject project) {
        ITmfProjectModelElement element;
        String name;
        ArrayList<ITmfProjectModelElement> children = new ArrayList<ITmfProjectModelElement>();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject(project, true);
        for (ITmfProjectModelElement element2 : tmfProject.getChildren()) {
            TmfProjectModelElement child;
            if (element2 instanceof TmfTraceFolder) {
                child = (TmfTraceFolder)element2;
                childrenMap.put(((TmfTraceFolder)child).getResource().getName(), child);
            }
            if (!(element2 instanceof TmfExperimentFolder)) continue;
            child = (TmfExperimentFolder)element2;
            childrenMap.put(((TmfExperimentFolder)child).getResource().getName(), child);
        }
        IFolder folder = project.getFolder("Traces");
        if (folder != null) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element == null) {
                element = new TmfTraceFolder("Traces", folder, tmfProject);
            }
            children.add(element);
            childrenMap.remove(name);
            this.getTraceFolderChildren((TmfTraceFolder)element);
        }
        if ((folder = project.getFolder("Experiments")) != null) {
            name = folder.getName();
            element = (ITmfProjectModelElement)childrenMap.get(name);
            if (element == null) {
                element = new TmfExperimentFolder("Experiments", folder, tmfProject);
            }
            children.add(element);
            childrenMap.remove(name);
            this.getExperimentFolderChildren((TmfExperimentFolder)element);
        }
        this.cleanupModel(tmfProject, childrenMap);
        return children.toArray();
    }

    private Object[] getTraceFolderChildren(TmfTraceFolder tmfTraceFolder) {
        ArrayList<ITmfProjectModelElement> children = new ArrayList<ITmfProjectModelElement>();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : tmfTraceFolder.getChildren()) {
            if (!(element instanceof TmfTraceElement)) continue;
            String name = element.getResource().getName();
            childrenMap.put(name, element);
        }
        IFolder folder = tmfTraceFolder.getResource();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String name = resource.getName();
                ITmfProjectModelElement trace = (ITmfProjectModelElement)childrenMap.get(name);
                if (trace == null) {
                    trace = new TmfTraceElement(name, resource, tmfTraceFolder);
                }
                children.add(trace);
                childrenMap.remove(name);
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        this.cleanupModel(tmfTraceFolder, childrenMap);
        return children.toArray();
    }

    private Object[] getExperimentFolderChildren(TmfExperimentFolder tmfExperimentFolder) {
        ArrayList<ITmfProjectModelElement> children = new ArrayList<ITmfProjectModelElement>();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : tmfExperimentFolder.getChildren()) {
            if (!(element instanceof TmfExperimentElement)) continue;
            String name = element.getResource().getName();
            childrenMap.put(name, element);
        }
        IFolder folder = tmfExperimentFolder.getResource();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    IFolder expFolder = (IFolder)resource;
                    String name = resource.getName();
                    ITmfProjectModelElement experiment = (ITmfProjectModelElement)childrenMap.get(name);
                    if (experiment == null) {
                        experiment = new TmfExperimentElement(name, expFolder, tmfExperimentFolder);
                    }
                    children.add(experiment);
                    childrenMap.remove(name);
                    this.getExperimentChildren((TmfExperimentElement)experiment);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        this.cleanupModel(tmfExperimentFolder, childrenMap);
        return children.toArray();
    }

    private Object[] getExperimentChildren(TmfExperimentElement tmfExperiment) {
        ArrayList<ITmfProjectModelElement> children = new ArrayList<ITmfProjectModelElement>();
        HashMap<String, ITmfProjectModelElement> childrenMap = new HashMap<String, ITmfProjectModelElement>();
        for (ITmfProjectModelElement element : tmfExperiment.getChildren()) {
            if (!(element instanceof TmfTraceElement)) continue;
            String name = element.getResource().getName();
            childrenMap.put(name, element);
        }
        IFolder folder = tmfExperiment.getResource();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                String name = resource.getName();
                ITmfProjectModelElement trace = (ITmfProjectModelElement)childrenMap.get(name);
                if (trace == null && !resource.isHidden()) {
                    trace = new TmfTraceElement(name, resource, tmfExperiment);
                }
                children.add(trace);
                childrenMap.remove(name);
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        this.cleanupModel(tmfExperiment, childrenMap);
        return children.toArray();
    }

    private void cleanupModel(ITmfProjectModelElement parent, Map<String, ITmfProjectModelElement> danglingChildren) {
        if (parent != null) {
            for (ITmfProjectModelElement child : danglingChildren.values()) {
                HashMap<String, ITmfProjectModelElement> grandChildren = new HashMap<String, ITmfProjectModelElement>();
                for (ITmfProjectModelElement element : child.getChildren()) {
                    String name = element.getResource().getName();
                    grandChildren.put(name, element);
                }
                this.cleanupModel(child, grandChildren);
                parent.removeChild(child);
            }
        }
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        TmfNavigatorContentProvider.customizeTmfElements(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        TmfNavigatorContentProvider.customizeTmfElements(this.getElements(input), currentElements);
    }

    private static void customizeTmfElements(Object[] elements, Set<Object> children) {
        if (elements != null && children != null) {
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof ITmfProjectModelElement) {
                    ITmfProjectModelElement tmfElement = (ITmfProjectModelElement)element;
                    IResource resource = tmfElement.getResource();
                    if (resource != null) {
                        children.remove(resource);
                    }
                    children.add(element);
                } else if (element != null) {
                    children.add(element);
                }
                ++n2;
            }
        }
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return anAddModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return null;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }
}

