/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.LinkedList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteTraceHandler
extends AbstractHandler {
    private TreeSelection fSelection = null;

    public boolean isEnabled() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fSelection = null;
        if (selection instanceof TreeSelection) {
            this.fSelection = (TreeSelection)selection;
            for (Object element : this.fSelection) {
                if (element instanceof TmfTraceElement) continue;
                return false;
            }
        }
        return !selection.isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell shell = window.getShell();
        MessageBox confirmOperation = new MessageBox(shell, 292);
        confirmOperation.setText(Messages.DeleteDialog_Title);
        confirmOperation.setMessage(Messages.DeleteTraceHandler_Message);
        if (confirmOperation.open() != 32) {
            return null;
        }
        for (Object element : this.fSelection) {
            if (!(element instanceof TmfTraceElement)) continue;
            TmfTraceElement trace = (TmfTraceElement)element;
            IResource resource = trace.getResource();
            try {
                IPath path = resource.getLocation();
                if (path != null && trace.getParent() instanceof TmfTraceFolder) {
                    String location = path.toString();
                    TmfExperimentFolder experimentFolder = trace.getProject().getExperimentsFolder();
                    for (ITmfProjectModelElement experiment : experimentFolder.getChildren()) {
                        LinkedList<ITmfProjectModelElement> toRemove = new LinkedList<ITmfProjectModelElement>();
                        for (ITmfProjectModelElement child : experiment.getChildren()) {
                            if (!child.getResource().getLocation().toString().equals(location)) continue;
                            toRemove.add(child);
                        }
                        for (ITmfProjectModelElement child : toRemove) {
                            experiment.removeChild(child);
                            child.getResource().delete(true, null);
                        }
                    }
                }
                resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
                trace.deleteSupplementaryFolder();
                trace.getProject().refresh();
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error deleting trace: " + trace.getName(), e);
            }
        }
        return null;
    }
}

