/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources.ResourcesEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.swt.graphics.RGB;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    public String getStateTypeName() {
        return Messages.ResourcesView_stateTypeName;
    }

    public StateItem[] getStateTable() {
        StateItem[] stateTable = new StateItem[State.values().length];
        int i = 0;
        while (i < stateTable.length) {
            State state = State.values()[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof ResourcesEvent) {
            ResourcesEvent resourcesEvent = (ResourcesEvent)event;
            if (resourcesEvent.getType() == ResourcesEntry.Type.CPU) {
                int status = resourcesEvent.getValue();
                if (status == 0) {
                    return State.IDLE.ordinal();
                }
                if (status == 1) {
                    return State.USERMODE.ordinal();
                }
                if (status == 2) {
                    return State.SYSCALL.ordinal();
                }
                if (status == 3) {
                    return State.IRQ.ordinal();
                }
                if (status == 4) {
                    return State.SOFT_IRQ.ordinal();
                }
            } else {
                if (resourcesEvent.getType() == ResourcesEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE.ordinal();
                }
                if (resourcesEvent.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                    int cpu = resourcesEvent.getValue();
                    if (cpu == -2) {
                        return State.SOFT_IRQ_RAISED.ordinal();
                    }
                    return State.SOFT_IRQ_ACTIVE.ordinal();
                }
                return -1;
            }
        }
        return State.UNKNOWN.ordinal();
    }

    public String getEventName(ITimeEvent event) {
        if (event instanceof ResourcesEvent) {
            ResourcesEvent resourcesEvent = (ResourcesEvent)event;
            if (resourcesEvent.getType() == ResourcesEntry.Type.CPU) {
                int status = resourcesEvent.getValue();
                if (status == 0) {
                    return State.IDLE.toString();
                }
                if (status == 1) {
                    return State.USERMODE.toString();
                }
                if (status == 2) {
                    return State.SYSCALL.toString();
                }
                if (status == 3) {
                    return State.IRQ.toString();
                }
                if (status == 4) {
                    return State.SOFT_IRQ.toString();
                }
            } else {
                if (resourcesEvent.getType() == ResourcesEntry.Type.IRQ) {
                    return State.IRQ_ACTIVE.toString();
                }
                if (resourcesEvent.getType() == ResourcesEntry.Type.SOFT_IRQ) {
                    int cpu = resourcesEvent.getValue();
                    if (cpu == -2) {
                        return State.SOFT_IRQ_RAISED.toString();
                    }
                    return State.SOFT_IRQ_ACTIVE.toString();
                }
                return null;
            }
        }
        return State.UNKNOWN.toString();
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        if (event instanceof ResourcesEvent) {
            int cpu;
            ResourcesEvent resourcesEvent = (ResourcesEvent)event;
            if ((resourcesEvent.getType().equals((Object)ResourcesEntry.Type.IRQ) || resourcesEvent.getType().equals((Object)ResourcesEntry.Type.SOFT_IRQ)) && (cpu = resourcesEvent.getValue()) >= 0) {
                retMap.put(Messages.ResourcesView_attributeCpuName, String.valueOf(cpu));
            }
            if (resourcesEvent.getType().equals((Object)ResourcesEntry.Type.CPU)) {
                int status = resourcesEvent.getValue();
                if (status == 3) {
                    ResourcesEntry entry = (ResourcesEntry)event.getEntry();
                    IStateSystemQuerier ssq = entry.getTrace().getStateSystem();
                    int cpu2 = entry.getId();
                    IStateSystemQuerier ss = entry.getTrace().getStateSystem();
                    try {
                        List fullState = ss.queryFullState(event.getTime());
                        List irqQuarks = ss.getQuarks(new String[]{"Resources", "IRQs", "*"});
                        Iterator iterator = irqQuarks.iterator();
                        while (iterator.hasNext()) {
                            int irqQuark = (Integer)iterator.next();
                            if (((ITmfStateInterval)fullState.get(irqQuark)).getStateValue().unboxInt() != cpu2) continue;
                            ITmfStateInterval value = ssq.querySingleState(event.getTime(), irqQuark);
                            if (!value.getStateValue().isNull()) {
                                int irq = Integer.parseInt(ssq.getAttributeName(irqQuark));
                                retMap.put(Messages.ResourcesView_attributeIrqName, String.valueOf(irq));
                            }
                            break;
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                } else if (status == 4) {
                    ResourcesEntry entry = (ResourcesEntry)event.getEntry();
                    IStateSystemQuerier ssq = entry.getTrace().getStateSystem();
                    int cpu3 = entry.getId();
                    IStateSystemQuerier ss = entry.getTrace().getStateSystem();
                    try {
                        List fullState = ss.queryFullState(event.getTime());
                        List softIrqQuarks = ss.getQuarks(new String[]{"Resources", "Soft_IRQs", "*"});
                        Iterator iterator = softIrqQuarks.iterator();
                        while (iterator.hasNext()) {
                            int softIrqQuark = (Integer)iterator.next();
                            if (((ITmfStateInterval)fullState.get(softIrqQuark)).getStateValue().unboxInt() != cpu3) continue;
                            ITmfStateInterval value = ssq.querySingleState(event.getTime(), softIrqQuark);
                            if (!value.getStateValue().isNull()) {
                                int softIrq = Integer.parseInt(ssq.getAttributeName(softIrqQuark));
                                retMap.put(Messages.ResourcesView_attributeSoftIrqName, String.valueOf(softIrq));
                            }
                            break;
                        }
                    }
                    catch (AttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (TimeRangeException e) {
                        e.printStackTrace();
                    }
                    catch (StateValueTypeException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return retMap;
    }

    private static enum State {
        UNKNOWN(new RGB(100, 100, 100)),
        IDLE(new RGB(200, 200, 200)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        IRQ(new RGB(200, 100, 100)),
        SOFT_IRQ(new RGB(200, 150, 100)),
        IRQ_ACTIVE(new RGB(200, 100, 100)),
        SOFT_IRQ_RAISED(new RGB(200, 200, 0)),
        SOFT_IRQ_ACTIVE(new RGB(200, 150, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

