/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.elements.adapters;

import java.math.BigInteger;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.core.model.IDisassemblyInstruction;
import org.eclipse.cdt.debug.ui.disassembly.IElementToggleBreakpointAdapter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;

public class DisassemblyToggleBreakpointAdapter
implements IElementToggleBreakpointAdapter {
    @Override
    public boolean canToggleLineBreakpoints(IPresentationContext presentationContext, Object element) {
        return element instanceof IDisassemblyInstruction;
    }

    @Override
    public void toggleLineBreakpoints(IPresentationContext presentationContext, Object element) throws CoreException {
        if (element instanceof IDisassemblyInstruction) {
            IDisassemblyInstruction instruction = (IDisassemblyInstruction)element;
            IBreakpoint breakpoint = this.findBreakpoint(instruction);
            if (breakpoint != null) {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
            } else {
                IAddress address = instruction.getAdress();
                CDIDebugModel.createAddressBreakpoint(null, (String)"", (IResource)ResourcesPlugin.getWorkspace().getRoot(), (int)0, (int)-1, (IAddress)address, (boolean)true, (int)0, (String)"", (boolean)true);
            }
        }
    }

    private IBreakpoint findBreakpoint(IDisassemblyInstruction instruction) {
        IBreakpoint[] breakpoints;
        BigInteger address = instruction.getAdress().getValue();
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (bp instanceof ICLineBreakpoint) {
                try {
                    IAddress bpAddress = ((ICDebugTarget)instruction.getDebugTarget()).getBreakpointAddress((ICLineBreakpoint)bp);
                    if (bpAddress != null && address.compareTo(bpAddress.getValue()) == 0) {
                        return bp;
                    }
                }
                catch (DebugException debugException) {}
            }
            ++n2;
        }
        return null;
    }
}

