/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions.breakpoints;

import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManagerListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class CAddBreakpointInteractiveRulerAction
extends Action
implements IUpdate {
    private IWorkbenchPart fPart;
    private IDocument fDocument;
    private IVerticalRulerInfo fRulerInfo;
    private IToggleBreakpointsTargetManagerListener fListener = new IToggleBreakpointsTargetManagerListener(){

        public void preferredTargetsChanged() {
            CAddBreakpointInteractiveRulerAction.this.update();
        }
    };

    public CAddBreakpointInteractiveRulerAction(IWorkbenchPart part, IDocument document, IVerticalRulerInfo rulerInfo) {
        super(ActionMessages.getString("CAddBreakpointInteractiveRulerAction_label"));
        this.fPart = part;
        this.fDocument = document;
        this.fRulerInfo = rulerInfo;
        DebugUITools.getToggleBreakpointsTargetManager().addChangedListener(this.fListener);
    }

    public void run() {
        IDocument document = this.getDocument();
        if (document == null) {
            return;
        }
        int line = this.fRulerInfo.getLineOfLastMouseButtonActivity();
        if (line == -1) {
            return;
        }
        try {
            IToggleBreakpointsTargetCExtension extension;
            ITextSelection selection = this.getTextSelection(document, line);
            IToggleBreakpointsTarget toggleTarget = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
            if (toggleTarget instanceof IToggleBreakpointsTargetCExtension && (extension = (IToggleBreakpointsTargetCExtension)toggleTarget).canCreateLineBreakpointsInteractive(this.fPart, (ISelection)selection)) {
                extension.createLineBreakpointsInteractive(this.fPart, (ISelection)selection);
            }
        }
        catch (BadLocationException e) {
            this.reportException((Exception)((Object)e));
        }
        catch (CoreException e) {
            this.reportException((Exception)((Object)e));
        }
    }

    private void reportException(Exception e) {
        Status status = new Status(4, "org.eclipse.cdt.debug.ui", "Error creating breakpoint: ", (Throwable)e);
        ErrorDialog.openError((Shell)this.fPart.getSite().getShell(), (String)ActionMessages.getString("CAddBreakpointInteractiveRulerAction_error_title"), (String)ActionMessages.getString("CAddBreakpointInteractiveRulerAction_error_message"), (IStatus)status);
        CDebugUIPlugin.log((IStatus)status);
    }

    public void dispose() {
        this.fDocument = null;
        this.fPart = null;
        this.fRulerInfo = null;
        DebugUITools.getToggleBreakpointsTargetManager().removeChangedListener(this.fListener);
    }

    private IDocument getDocument() {
        ITextEditor editor;
        IDocumentProvider provider;
        if (this.fDocument != null) {
            return this.fDocument;
        }
        if (this.fPart instanceof ITextEditor && (provider = (editor = (ITextEditor)this.fPart).getDocumentProvider()) != null) {
            return provider.getDocument((Object)editor.getEditorInput());
        }
        IDocument doc = (IDocument)this.fPart.getAdapter(IDocument.class);
        if (doc != null) {
            return doc;
        }
        return null;
    }

    public void update() {
        int line;
        IDocument document = this.getDocument();
        if (document != null && (line = this.fRulerInfo.getLineOfLastMouseButtonActivity()) > -1) {
            try {
                IToggleBreakpointsTargetCExtension extension;
                ITextSelection selection = this.getTextSelection(document, line);
                IToggleBreakpointsTarget adapter = DebugUITools.getToggleBreakpointsTargetManager().getToggleBreakpointsTarget(this.fPart, (ISelection)selection);
                if (adapter == null) {
                    this.setEnabled(false);
                    return;
                }
                if (adapter instanceof IToggleBreakpointsTargetCExtension && (extension = (IToggleBreakpointsTargetCExtension)adapter).canCreateLineBreakpointsInteractive(this.fPart, (ISelection)selection)) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (BadLocationException e) {
                this.reportException((Exception)((Object)e));
            }
        }
        this.setEnabled(false);
    }

    private ITextSelection getTextSelection(IDocument document, int line) throws BadLocationException {
        ISelection selection;
        IRegion region = document.getLineInformation(line);
        TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
            textSelection = (ITextSelection)selection;
        }
        return textSelection;
    }
}

