/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.composite;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.DefaultFragmentBindingComparator;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBindingComparator;
import org.eclipse.cdt.internal.core.index.composite.CompositingNotImplementedError;
import org.eclipse.cdt.internal.core.index.composite.ICompositesFactory;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFragmentBindingComparator;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCompositeFactory
implements ICompositesFactory {
    protected IIndex index;
    private Comparator<IIndexFragmentBinding> fragmentComparator;

    public AbstractCompositeFactory(IIndex index) {
        this.index = index;
        this.fragmentComparator = new FragmentBindingComparator(new IIndexFragmentBindingComparator[]{new PDOMFragmentBindingComparator(), new DefaultFragmentBindingComparator()});
    }

    protected final IType[] getCompositeTypes(IType[] types) {
        IType[] result = types;
        int i = 0;
        while (i < types.length) {
            IType type = this.getCompositeType(types[i]);
            if (result != types) {
                result[i] = type;
            } else if (type != types[i]) {
                result = new IType[types.length];
                if (i > 0) {
                    System.arraycopy(types, 0, result, 0, i);
                }
                result[i] = type;
            }
            ++i;
        }
        return result;
    }

    @Override
    public final IIndexBinding[] getCompositeBindings(IIndexFragmentBinding[][] fragmentBindings) {
        return this.getCompositeBindings(this.mergeBindingArrays(fragmentBindings));
    }

    private final IIndexBinding[] getCompositeBindings(IIndexFragmentBinding[] bindings) {
        IIndexBinding[] result = new IIndexBinding[bindings.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getCompositeBinding(bindings[i]);
            ++i;
        }
        return result;
    }

    @Override
    public final IIndexFragmentBinding[] findEquivalentBindings(IBinding binding) {
        CIndex cindex = (CIndex)this.index;
        try {
            return cindex.findEquivalentBindings(binding);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
        }
    }

    protected IIndexFragmentBinding[] mergeBindingArrays(IIndexFragmentBinding[][] fragmentBindings) {
        TreeSet<IIndexFragmentBinding> ts = new TreeSet<IIndexFragmentBinding>(this.fragmentComparator);
        IIndexFragmentBinding[][] iIndexFragmentBindingArray = fragmentBindings;
        int n = fragmentBindings.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentBinding[] array = iIndexFragmentBindingArray[n2];
            if (array != null) {
                IIndexFragmentBinding[] iIndexFragmentBindingArray2 = array;
                int n3 = array.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIndexFragmentBinding element = iIndexFragmentBindingArray2[n4];
                    ts.add(element);
                    ++n4;
                }
            }
            ++n2;
        }
        return ts.toArray(new IIndexFragmentBinding[ts.size()]);
    }

    protected IIndexFragmentBinding findOneBinding(IBinding binding, boolean allowDeclaration) {
        try {
            IIndexFragmentBinding[] ibs = this.findEquivalentBindings(binding);
            IIndexFragmentBinding def = null;
            IIndexFragmentBinding dec = ibs.length > 0 ? ibs[0] : null;
            IIndexFragmentBinding[] iIndexFragmentBindingArray = ibs;
            int n = ibs.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragmentBinding ib = iIndexFragmentBindingArray[n2];
                if (ib.hasDefinition()) {
                    def = ib;
                } else if (allowDeclaration && ib.hasDeclaration()) {
                    dec = ib;
                }
                ++n2;
            }
            return def == null ? dec : def;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            throw new CompositingNotImplementedError();
        }
    }

    private static class FragmentBindingComparator
    implements Comparator<IIndexFragmentBinding> {
        private IIndexFragmentBindingComparator[] comparators;

        FragmentBindingComparator(IIndexFragmentBindingComparator[] comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(IIndexFragmentBinding f1, IIndexFragmentBinding f2) {
            IIndexFragmentBindingComparator[] iIndexFragmentBindingComparatorArray = this.comparators;
            int n = this.comparators.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragmentBindingComparator comparator = iIndexFragmentBindingComparatorArray[n2];
                int cmp = comparator.compare(f1, f2);
                if (cmp != Integer.MIN_VALUE) {
                    return cmp;
                }
                ++n2;
            }
            throw new IllegalArgumentException();
        }
    }
}

