/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPUnknownClass;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalUnknownScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CVQualifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExpressionTypes;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalMemberAccess
extends CPPEvaluation {
    private final IType fOwnerType;
    private final IBinding fMember;
    private final IASTExpression.ValueCategory fOwnerValueCategory;
    private final boolean fIsPointerDeref;
    private IType fType;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsValueDependent;
    private boolean fCheckedIsValueDependent;

    public EvalMemberAccess(IType ownerType, IASTExpression.ValueCategory ownerValueCat, IBinding member, boolean isPointerDeref) {
        this.fOwnerType = ownerType;
        this.fOwnerValueCategory = ownerValueCat;
        this.fMember = member;
        this.fIsPointerDeref = isPointerDeref;
    }

    public IType getOwnerType() {
        return this.fOwnerType;
    }

    public IASTExpression.ValueCategory getOwnerValueCategory() {
        return this.fOwnerValueCategory;
    }

    public IBinding getMember() {
        return this.fMember;
    }

    public boolean isPointerDeref() {
        return this.fIsPointerDeref;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = this.computeIsTypeDependent();
        }
        return this.fIsTypeDependent;
    }

    private boolean computeIsTypeDependent() {
        IType t;
        if (this.fMember instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fMember instanceof IEnumerator) {
            t = ((IEnumerator)this.fMember).getType();
        } else if (this.fMember instanceof IVariable) {
            t = ((IVariable)this.fMember).getType();
        } else if (this.fMember instanceof IFunction) {
            t = ((IFunction)this.fMember).getType();
        } else {
            return false;
        }
        return CPPTemplates.isDependentType(t);
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = this.computeIsValueDependent();
        }
        return this.fIsValueDependent;
    }

    private boolean computeIsValueDependent() {
        if (this.fMember instanceof ICPPUnknownBinding) {
            return true;
        }
        if (this.fMember instanceof IEnumerator) {
            return Value.isDependentValue(((IEnumerator)this.fMember).getValue());
        }
        if (this.fMember instanceof IVariable) {
            return Value.isDependentValue(((IVariable)this.fMember).getInitialValue());
        }
        if (this.fMember instanceof IFunction) {
            return false;
        }
        return false;
    }

    public static IType getFieldOwnerType(IType fieldOwnerExpressionType, boolean isDeref, IASTNode point, Collection<ICPPFunction> functionBindings, boolean returnUnnamed) {
        IType prValue;
        IType type = fieldOwnerExpressionType;
        if (!isDeref) {
            return type;
        }
        int j = 0;
        while (j < 20) {
            ICPPEvaluation[] args;
            ICPPFunction op;
            IScope scope;
            IType classType = SemanticUtil.getUltimateTypeUptoPointers(type);
            if (!(classType instanceof ICPPClassType) || (scope = ((ICPPClassType)classType).getCompositeScope()) == null || scope instanceof ICPPInternalUnknownScope || (op = CPPSemantics.findOverloadedOperator(point, args = new ICPPEvaluation[]{new EvalFixed(type, IASTExpression.ValueCategory.LVALUE, Value.UNKNOWN)}, classType, OverloadableOperator.ARROW, CPPSemantics.LookupMode.NO_GLOBALS)) == null) break;
            if (functionBindings != null) {
                functionBindings.add(op);
            }
            type = ExpressionTypes.typeFromFunctionCall(op);
            type = SemanticUtil.mapToAST(type, point);
            ++j;
        }
        if ((prValue = ExpressionTypes.prvalueTypeWithResolvedTypedefs(type)) instanceof IPointerType) {
            return ExpressionTypes.glvalueType(((IPointerType)prValue).getType());
        }
        if (CPPTemplates.isDependentType(type)) {
            return returnUnnamed ? CPPUnknownClass.createUnnamedInstance() : null;
        }
        return new ProblemType(10004);
    }

    @Override
    public IType getTypeOrFunctionSet(IASTNode point) {
        if (this.fType == null) {
            this.fType = this.computeType(point);
        }
        return this.fType;
    }

    private IType computeType(IASTNode point) {
        if (this.fMember instanceof ICPPUnknownBinding) {
            return new TypeOfDependentExpression(this);
        }
        if (this.fMember instanceof IEnumerator) {
            return ((IEnumerator)this.fMember).getType();
        }
        if (this.fMember instanceof IVariable) {
            IType e2 = ((IVariable)this.fMember).getType();
            if ((e2 = SemanticUtil.getNestedType(e2, 1)) instanceof ICPPUnknownType) {
                return new TypeOfDependentExpression(this);
            }
            if (e2 instanceof ICPPReferenceType) {
                e2 = ExpressionTypes.glvalueType(e2);
            } else if (this.fMember instanceof ICPPField && !((ICPPField)this.fMember).isStatic()) {
                e2 = this.addQualifiersForAccess((ICPPField)this.fMember, e2, this.fOwnerType);
                e2 = !this.fIsPointerDeref && this.fOwnerValueCategory == IASTExpression.ValueCategory.PRVALUE ? ExpressionTypes.prvalueType(e2) : ExpressionTypes.glvalueType(e2);
            }
            return SemanticUtil.mapToAST(e2, point);
        }
        if (this.fMember instanceof IFunction) {
            return SemanticUtil.mapToAST(((IFunction)this.fMember).getType(), point);
        }
        return ProblemType.UNKNOWN_FOR_EXPRESSION;
    }

    private IType addQualifiersForAccess(ICPPField field, IType fieldType, IType ownerType) {
        CVQualifier cvq1 = SemanticUtil.getCVQualifier(ownerType);
        CVQualifier cvq2 = SemanticUtil.getCVQualifier(fieldType);
        if (field.isMutable()) {
            if (cvq2.isConst()) {
                fieldType = SemanticUtil.getNestedType(fieldType, 21);
            }
            fieldType = SemanticUtil.addQualifiers(fieldType, false, cvq1.isVolatile() || cvq2.isVolatile(), cvq2.isRestrict());
        } else {
            fieldType = SemanticUtil.addQualifiers(fieldType, cvq1.isConst(), cvq1.isVolatile(), cvq2.isRestrict());
        }
        return fieldType;
    }

    @Override
    public IValue getValue(IASTNode point) {
        if (this.fMember instanceof IEnumerator) {
            return ((IEnumerator)this.fMember).getValue();
        }
        if (this.fMember instanceof IVariable) {
            return ((IVariable)this.fMember).getInitialValue();
        }
        if (this.fMember instanceof IFunction) {
            return Value.UNKNOWN;
        }
        return Value.create(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        if (this.fMember instanceof IVariable) {
            IType e2 = ((IVariable)this.fMember).getType();
            if ((e2 = SemanticUtil.getNestedType(e2, 1)) instanceof ICPPReferenceType) {
                return IASTExpression.ValueCategory.LVALUE;
            }
            if (this.fMember instanceof ICPPField && !((ICPPField)this.fMember).isStatic()) {
                if (this.fIsPointerDeref) {
                    return IASTExpression.ValueCategory.LVALUE;
                }
                return this.fOwnerValueCategory;
            }
            return IASTExpression.ValueCategory.LVALUE;
        }
        if (this.fMember instanceof IFunction) {
            return IASTExpression.ValueCategory.LVALUE;
        }
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        int firstByte = 12;
        if (this.fIsPointerDeref) {
            firstByte |= 0x10;
        }
        if (this.fOwnerValueCategory == IASTExpression.ValueCategory.LVALUE) {
            firstByte |= 0x20;
        } else if (this.fOwnerValueCategory == IASTExpression.ValueCategory.XVALUE) {
            firstByte |= 0x40;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.fOwnerType);
        buffer.marshalBinding(this.fMember);
    }

    public static ISerializableEvaluation unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        boolean isDeref;
        boolean bl = isDeref = (firstByte & 0x10) != 0;
        IASTExpression.ValueCategory ownerValueCat = (firstByte & 0x20) != 0 ? IASTExpression.ValueCategory.LVALUE : ((firstByte & 0x40) != 0 ? IASTExpression.ValueCategory.XVALUE : IASTExpression.ValueCategory.PRVALUE);
        IType ownerType = buffer.unmarshalType();
        IBinding member = buffer.unmarshalBinding();
        return new EvalMemberAccess(ownerType, ownerValueCat, member, isDeref);
    }

    @Override
    public ICPPEvaluation instantiate(ICPPTemplateParameterMap tpMap, int packOffset, ICPPClassSpecialization within, int maxdepth, IASTNode point) {
        IType ownerType = CPPTemplates.instantiateType(this.fOwnerType, tpMap, packOffset, within, point);
        if (ownerType == this.fOwnerType) {
            return this;
        }
        IBinding member = this.fMember;
        if (ownerType instanceof ICPPClassSpecialization) {
            member = CPPTemplates.createSpecialization((ICPPClassSpecialization)ownerType, this.fMember, point);
        }
        return new EvalMemberAccess(ownerType, this.fOwnerValueCategory, member, this.fIsPointerDeref);
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fOwnerType, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }
}

