/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.LookupData;

public class AccessContext {
    private static final int v_private = 3;
    private static final int v_protected = 2;
    public static final int v_public = 1;
    private final IASTName name;
    private IBinding[] context;
    private boolean isUnqualifiedLookup;
    private ICPPClassType namingClass;
    private ICPPClassType firstCandidateForNamingClass;
    private DOMException initializationException;

    public static boolean isAccessible(IBinding binding, IASTName from) {
        return new AccessContext(from).isAccessible(binding);
    }

    public static boolean isAccessible(IBinding binding, int bindingVisibility, IASTName from) {
        return new AccessContext(from).isAccessible(binding, bindingVisibility);
    }

    public AccessContext(IASTName name) {
        this.name = name;
    }

    public boolean isAccessible(IBinding binding) {
        int bindingVisibility = binding instanceof ICPPMember ? ((ICPPMember)binding).getVisibility() : 1;
        return this.isAccessible(binding, bindingVisibility);
    }

    public boolean isAccessible(IBinding binding, int bindingVisibility) {
        IBinding owner;
        while ((owner = binding.getOwner()) instanceof ICompositeType && ((ICompositeType)owner).isAnonymous()) {
            binding = owner;
        }
        if (!(owner instanceof ICPPClassType)) {
            return true;
        }
        ICPPClassType accessOwner = (ICPPClassType)owner;
        if (!this.initialize(accessOwner)) {
            return true;
        }
        if (this.namingClass == null) {
            return true;
        }
        return this.isAccessible(binding, bindingVisibility, (ICPPClassType)owner, this.namingClass, 1, 0);
    }

    private boolean initialize(ICPPClassType accessOwner) {
        if (this.context == null) {
            if (this.initializationException != null) {
                return false;
            }
            try {
                this.context = AccessContext.getContext(this.name);
                this.firstCandidateForNamingClass = this.getFirstCandidateForNamingClass(this.name);
            }
            catch (DOMException e) {
                CCorePlugin.log(e);
                this.initializationException = e;
                return false;
            }
        }
        this.namingClass = this.getNamingClass(accessOwner);
        return true;
    }

    private boolean isAccessible(IBinding binding, int bindingVisibility, ICPPClassType owner, ICPPClassType derivedClass, int accessLevel, int depth) {
        if (depth > 16) {
            return false;
        }
        accessLevel = this.getMemberAccessLevel(derivedClass, accessLevel);
        if (owner.isSameType(derivedClass)) {
            return AccessContext.isAccessible(bindingVisibility, accessLevel);
        }
        ICPPBase[] bases = ClassTypeHelper.getBases(derivedClass, this.name);
        if (bases != null) {
            ICPPBase[] iCPPBaseArray = bases;
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                IBinding baseBinding = base.getBaseClass();
                if (baseBinding instanceof ICPPDeferredClassInstance) {
                    baseBinding = ((ICPPDeferredClassInstance)baseBinding).getTemplateDefinition();
                }
                if (baseBinding instanceof ICPPClassType && AccessContext.isAccessible(base.getVisibility(), accessLevel) && this.isAccessible(binding, bindingVisibility, owner, (ICPPClassType)baseBinding, accessLevel == 3 ? 2 : accessLevel, depth + 1)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private int getMemberAccessLevel(ICPPClassType classType, int inheritedAccessLevel) {
        int accessLevel = inheritedAccessLevel;
        IBinding[] iBindingArray = this.context;
        int n = this.context.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType contextClass;
            IBinding contextBinding = iBindingArray[n2];
            if (ClassTypeHelper.isFriend(contextBinding, classType)) {
                return 3;
            }
            if (accessLevel == 1 && contextBinding instanceof ICPPClassType && this.isAccessibleBaseClass(classType, contextClass = (ICPPClassType)contextBinding, 0)) {
                accessLevel = 2;
            }
            ++n2;
        }
        return accessLevel;
    }

    private boolean isAccessibleBaseClass(ICPPClassType classType, ICPPClassType defived, int depth) {
        if (depth > 16) {
            return false;
        }
        if (defived.isSameType(classType)) {
            return true;
        }
        ICPPBase[] bases = defived.getBases();
        if (bases != null) {
            ICPPBase[] iCPPBaseArray = bases;
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                IBinding baseClass = base.getBaseClass();
                if (baseClass instanceof ICPPClassType && (depth <= 0 || AccessContext.isAccessible(base.getVisibility(), 2)) && this.isAccessibleBaseClass(classType, (ICPPClassType)baseClass, depth + 1)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private ICPPClassType getFirstCandidateForNamingClass(IASTName name) throws DOMException {
        LookupData data = new LookupData(name);
        this.isUnqualifiedLookup = !data.qualified;
        ICPPScope scope = CPPSemantics.getLookupScope(name);
        while (scope != null && !(scope instanceof ICPPClassScope)) {
            scope = CPPSemantics.getParentScope(scope, data.getTranslationUnit());
        }
        if (scope instanceof ICPPClassScope) {
            return ((ICPPClassScope)scope).getClassType();
        }
        return null;
    }

    private ICPPClassType getNamingClass(ICPPClassType accessOwner) {
        ICPPClassType classType = this.firstCandidateForNamingClass;
        if (classType != null && this.isUnqualifiedLookup) {
            IBinding owner = classType.getOwner();
            while (owner instanceof ICPPClassType && !AccessContext.derivesFrom(classType, accessOwner, 16)) {
                classType = (ICPPClassType)owner;
                owner = classType.getOwner();
            }
        }
        return classType;
    }

    private static boolean derivesFrom(ICPPClassType derived, ICPPClassType target, int maxdepth) {
        if (derived == target || derived.isSameType(target)) {
            return true;
        }
        if (maxdepth > 0) {
            ICPPBase[] iCPPBaseArray = derived.getBases();
            int n = iCPPBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase cppBase = iCPPBaseArray[n2];
                IBinding base = cppBase.getBaseClass();
                if (base instanceof ICPPClassType) {
                    ICPPClassType tbase = (ICPPClassType)base;
                    if (tbase.isSameType(target)) {
                        return true;
                    }
                    if (AccessContext.derivesFrom(tbase, target, maxdepth - 1)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    private static IBinding[] getContext(IASTName name) {
        IBinding[] accessibilityContext = IBinding.EMPTY_BINDING_ARRAY;
        IBinding binding = CPPVisitor.findEnclosingFunctionOrClass(name);
        while (binding != null) {
            if (!(binding instanceof ICPPMethod || binding instanceof IProblemBinding && ((IProblemBinding)binding).getID() == 13 || !(binding instanceof ICPPFunction) && !(binding instanceof ICPPClassType))) {
                accessibilityContext = ArrayUtil.append(accessibilityContext, binding);
            }
            binding = binding.getOwner();
        }
        return ArrayUtil.trim(accessibilityContext);
    }

    private static boolean isAccessible(int visibility, int accessLevel) {
        return accessLevel >= visibility;
    }
}

