/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInstanceCache;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalTemplate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPTemplateDefinition
extends PlatformObject
implements ICPPTemplateDefinition,
ICPPInternalTemplate {
    protected IASTName[] declarations;
    protected IASTName definition;
    private ICPPTemplateParameter[] templateParameters;
    private ObjectMap instances;
    private ICPPClassTemplate indexBinding = null;
    private boolean checkedIndex = false;

    public CPPTemplateDefinition(IASTName name) {
        if (name != null) {
            ASTNodeProperty prop = name.getPropertyInParent();
            if (prop == ICPPASTQualifiedName.SEGMENT_NAME) {
                prop = name.getParent().getPropertyInParent();
            }
            if (prop == IASTCompositeTypeSpecifier.TYPE_NAME) {
                this.definition = name;
            } else if (prop == IASTElaboratedTypeSpecifier.TYPE_NAME) {
                this.declarations = new IASTName[]{name};
            } else {
                IASTNode parent = name.getParent();
                while (!(parent instanceof IASTDeclaration)) {
                    parent = parent.getParent();
                }
                if (parent instanceof IASTFunctionDefinition) {
                    this.definition = name;
                } else {
                    this.declarations = new IASTName[]{name};
                }
            }
        }
    }

    @Override
    public final void addInstance(ICPPTemplateArgument[] arguments, ICPPTemplateInstance instance) {
        if (this.instances == null) {
            this.instances = new ObjectMap(2);
        }
        String key = ASTTypeUtil.getArgumentListString(arguments, true);
        this.instances.put(key, instance);
    }

    @Override
    public final ICPPTemplateInstance getInstance(ICPPTemplateArgument[] arguments) {
        String key;
        ICPPTemplateInstance cand;
        if (this.instances != null && (cand = (ICPPTemplateInstance)this.instances.get(key = ASTTypeUtil.getArgumentListString(arguments, true))) != null) {
            return cand;
        }
        ICPPClassTemplate ib = this.getIndexBinding();
        if (ib instanceof ICPPInstanceCache && (cand = ((ICPPInstanceCache)((Object)ib)).getInstance(arguments)) instanceof IIndexBinding && this.getTemplateName().getTranslationUnit().getIndexFileSet().containsDeclaration((IIndexBinding)((Object)cand))) {
            return cand;
        }
        return null;
    }

    protected ICPPClassTemplate getIndexBinding() {
        if (!this.checkedIndex) {
            IIndexBinding ib;
            IIndex index;
            IASTTranslationUnit tu;
            this.checkedIndex = true;
            IASTName name = this.getTemplateName();
            if (name != null && (tu = name.getTranslationUnit()) != null && (index = tu.getIndex()) != null && (ib = index.adaptBinding(this)) instanceof ICPPClassTemplate) {
                this.indexBinding = (ICPPClassTemplate)((Object)ib);
            }
        }
        return this.indexBinding;
    }

    @Override
    public ICPPTemplateInstance[] getAllInstances() {
        if (this.instances != null) {
            ICPPTemplateInstance[] result = new ICPPTemplateInstance[this.instances.size()];
            int i = 0;
            while (i < this.instances.size()) {
                result[i] = (ICPPTemplateInstance)this.instances.getAt(i);
                ++i;
            }
            return result;
        }
        return ICPPTemplateInstance.EMPTY_TEMPLATE_INSTANCE_ARRAY;
    }

    public IASTName getTemplateName() {
        if (this.definition != null) {
            return this.definition;
        }
        if (this.declarations != null && this.declarations.length > 0) {
            return this.declarations[0];
        }
        return null;
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        return this.getTemplateName().getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.getTemplateName());
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() {
        return true;
    }

    @Override
    public ICPPTemplateParameter[] getTemplateParameters() {
        if (this.templateParameters == null) {
            ICPPASTTemplateDeclaration template = CPPTemplates.getTemplateDeclaration(this.getTemplateName());
            if (template == null) {
                return ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
            }
            ICPPASTTemplateParameter[] params = template.getTemplateParameters();
            IBinding p = null;
            ICPPTemplateParameter[] result = null;
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter param = iCPPASTTemplateParameterArray[n2];
                p = CPPTemplates.getTemplateParameterName(param).resolveBinding();
                if (p instanceof ICPPTemplateParameter) {
                    result = ArrayUtil.append(ICPPTemplateParameter.class, result, (ICPPTemplateParameter)p);
                }
                ++n2;
            }
            this.templateParameters = ArrayUtil.trim(ICPPTemplateParameter.class, result);
        }
        return this.templateParameters;
    }

    @Override
    public void addDefinition(IASTNode node) {
        if (node instanceof ICPPASTCompositeTypeSpecifier && (node = ((ICPPASTCompositeTypeSpecifier)node).getName()) instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)node).getNames();
            node = ns[ns.length - 1];
        }
        if (!(node instanceof IASTName)) {
            return;
        }
        this.updateTemplateParameterBindings((IASTName)node);
        this.definition = (IASTName)node;
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (node instanceof ICPPASTElaboratedTypeSpecifier && (node = ((ICPPASTElaboratedTypeSpecifier)node).getName()) instanceof ICPPASTQualifiedName) {
            IASTName[] ns = ((ICPPASTQualifiedName)node).getNames();
            node = ns[ns.length - 1];
        }
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName declName = (IASTName)node;
        this.updateTemplateParameterBindings(declName);
        this.declarations = this.declarations == null ? new IASTName[]{declName} : (this.declarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.declarations[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.declarations, declName) : ArrayUtil.append(IASTName.class, this.declarations, declName));
    }

    @Override
    public IBinding resolveTemplateParameter(ICPPTemplateParameter templateParameter) {
        short pos = templateParameter.getParameterPosition();
        int tdeclLen = this.declarations == null ? 0 : this.declarations.length;
        int i = -1;
        while (i < tdeclLen) {
            block4: {
                ICPPASTTemplateParameter[] params;
                IASTName tdecl;
                block3: {
                    block2: {
                        if (i != -1) break block2;
                        tdecl = this.definition;
                        if (tdecl != null) break block3;
                        break block4;
                    }
                    tdecl = this.declarations[i];
                    if (tdecl == null) break;
                }
                if (pos < (params = CPPTemplates.getTemplateDeclaration(tdecl).getTemplateParameters()).length) {
                    IASTName oName = CPPTemplates.getTemplateParameterName(params[pos]);
                    return oName.resolvePreBinding();
                }
            }
            ++i;
        }
        return templateParameter;
    }

    protected final void updateTemplateParameterBindings(IASTName name) {
        ICPPASTTemplateDeclaration templateDeclaration = CPPTemplates.getTemplateDeclaration(name);
        if (templateDeclaration == null) {
            return;
        }
        ICPPASTTemplateParameter[] updateParams = templateDeclaration.getTemplateParameters();
        int k = 0;
        int tdeclLen = this.declarations == null ? 0 : this.declarations.length;
        int i = -1;
        while (i < tdeclLen && k < updateParams.length) {
            block5: {
                IASTName tdecl;
                block4: {
                    block3: {
                        if (i != -1) break block3;
                        tdecl = this.definition;
                        if (tdecl != null) break block4;
                        break block5;
                    }
                    tdecl = this.declarations[i];
                    if (tdecl == null) break;
                }
                ICPPASTTemplateParameter[] params = CPPTemplates.getTemplateDeclaration(tdecl).getTemplateParameters();
                int end = Math.min(params.length, updateParams.length);
                while (k < end) {
                    IASTName oName = CPPTemplates.getTemplateParameterName(params[k]);
                    IBinding b = oName.resolvePreBinding();
                    IASTName n = CPPTemplates.getTemplateParameterName(updateParams[k]);
                    n.setBinding(b);
                    ASTInternal.addDeclaration(b, n);
                    ++k;
                }
            }
            ++i;
        }
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.declarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.definition;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public final IBinding getOwner() {
        IASTName templateName = this.getTemplateName();
        if (templateName == null) {
            return null;
        }
        return CPPVisitor.findNameOwner(templateName, false);
    }

    public static final class CPPTemplateProblem
    extends ProblemBinding
    implements ICPPTemplateDefinition {
        public CPPTemplateProblem(IASTNode node, int id, char[] arg) {
            super(node, id, arg);
        }

        @Override
        public ICPPTemplateParameter[] getTemplateParameters() {
            return ICPPTemplateParameter.EMPTY_TEMPLATE_PARAMETER_ARRAY;
        }

        public ICPPClassTemplatePartialSpecialization[] getTemplateSpecializations() throws DOMException {
            throw new DOMException(this);
        }
    }
}

