/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICPointerType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CPointerType
implements ICPointerType,
ITypeContainer,
ISerializableType {
    public static final int IS_CONST = 1;
    public static final int IS_RESTRICT = 2;
    public static final int IS_VOLATILE = 4;
    IType nextType = null;
    private int qualifiers = 0;

    public CPointerType() {
    }

    public CPointerType(IType next, int qualifiers) {
        this.nextType = next;
        this.qualifiers = qualifiers;
    }

    @Override
    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICPointerType) {
            ICPointerType pt = (ICPointerType)obj;
            if (this.isConst() != pt.isConst()) {
                return false;
            }
            if (this.isRestrict() != pt.isRestrict()) {
                return false;
            }
            if (this.isVolatile() != pt.isVolatile()) {
                return false;
            }
            return pt.getType().isSameType(this.nextType);
        }
        return false;
    }

    @Override
    public boolean isRestrict() {
        return (this.qualifiers & 2) != 0;
    }

    @Override
    public IType getType() {
        return this.nextType;
    }

    @Override
    public void setType(IType type) {
        this.nextType = type;
    }

    @Override
    public boolean isConst() {
        return (this.qualifiers & 1) != 0;
    }

    @Override
    public boolean isVolatile() {
        return (this.qualifiers & 4) != 0;
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    public void setQualifiers(int qualifiers) {
        this.qualifiers = qualifiers;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int firstByte = 2;
        if (this.isConst()) {
            firstByte |= 0x10;
        }
        if (this.isVolatile()) {
            firstByte |= 0x20;
        }
        if (this.isRestrict()) {
            firstByte |= 0x40;
        }
        buffer.putByte((byte)firstByte);
        buffer.marshalType(this.getType());
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        IType nested = buffer.unmarshalType();
        return new CPointerType(nested, firstByte / 16);
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

