/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTCastExpression
extends ASTNode
implements IASTCastExpression,
IASTAmbiguityParent {
    private int operator = 0;
    private IASTExpression operand;
    private IASTTypeId typeId;

    public CASTCastExpression() {
    }

    public CASTCastExpression(IASTTypeId typeId, IASTExpression operand) {
        this();
        this.setOperand(operand);
        this.setTypeId(typeId);
    }

    @Override
    public CASTCastExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTCastExpression copy(IASTNode.CopyStyle style) {
        CASTCastExpression copy = new CASTCastExpression();
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy(style));
        IASTExpression operand = this.getOperand();
        copy.setOperand(operand == null ? null : operand.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public int getOperator() {
        return this.operator;
    }

    @Override
    public void setOperator(int value) {
        this.assertNotFrozen();
        this.operator = value;
    }

    @Override
    public IASTExpression getOperand() {
        return this.operand;
    }

    @Override
    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        IASTExpression operand = this.getOperand();
        if (operand != null && !operand.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (IASTExpression)other;
        }
    }

    @Override
    public IType getExpressionType() {
        IASTTypeId id = this.getTypeId();
        return CVisitor.createType(id.getAbstractDeclarator());
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }
}

