/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.Assert;

public class CASTAmbiguousDeclarator
extends ASTAmbiguousNode
implements IASTAmbiguousDeclarator {
    private IASTDeclarator[] dtors = new IASTDeclarator[2];
    private int dtorPos = -1;

    public CASTAmbiguousDeclarator(IASTDeclarator ... decls) {
        IASTDeclarator[] iASTDeclaratorArray = decls;
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclarator d = iASTDeclaratorArray[n2];
            if (d != null) {
                this.addDeclarator(d);
            }
            ++n2;
        }
    }

    @Override
    protected void beforeResolution() {
        IScope scope = CVisitor.getContainingScope(this);
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)scope).populateCache();
        }
    }

    @Override
    public void addDeclarator(IASTDeclarator d) {
        this.assertNotFrozen();
        if (d != null) {
            this.dtors = ArrayUtil.appendAt(IASTDeclarator.class, this.dtors, ++this.dtorPos, d);
            d.setParent(this);
            d.setPropertyInParent(SUBDECLARATOR);
        }
    }

    @Override
    public IASTDeclarator[] getDeclarators() {
        this.dtors = ArrayUtil.trimAt(IASTDeclarator.class, this.dtors, this.dtorPos);
        return this.dtors;
    }

    @Override
    public IASTNode[] getNodes() {
        return this.getDeclarators();
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.dtors[0].getInitializer();
    }

    @Override
    public IASTName getName() {
        return this.dtors[0].getName();
    }

    @Override
    public IASTDeclarator getNestedDeclarator() {
        return this.dtors[0].getNestedDeclarator();
    }

    @Override
    public IASTPointerOperator[] getPointerOperators() {
        return this.dtors[0].getPointerOperators();
    }

    @Override
    public IASTAttribute[] getAttributes() {
        return this.dtors[0].getAttributes();
    }

    @Override
    public void addAttribute(IASTAttribute attribute) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public int getRoleForName(IASTName name) {
        return this.dtors[0].getRoleForName(name);
    }

    @Override
    public void addPointerOperator(IASTPointerOperator operator) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public void setNestedDeclarator(IASTDeclarator nested) {
        this.assertNotFrozen();
        Assert.isLegal((boolean)false);
    }

    @Override
    public IASTDeclarator copy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTDeclarator copy(IASTNode.CopyStyle style) {
        throw new UnsupportedOperationException();
    }
}

