# vim:tabstop=4:shiftwidth=4:softtabstop=0:noexpandtab

define COPY_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/files/$(call PRUNE_TO_MODULE_DIRECTORY,$(2)): $(2)
	@echo $$<
	$(quiet)$(MKDIR) -p $$(dir $$@)
	$(quiet)cp -f $$< $$@
endef

define PREPROCESS_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/files/$(call PRUNE_TO_MODULE_DIRECTORY,$(2)): \
  $(2) $(WORK_DIRECTORY)/$(PROJECT_NAME)/project/.makefile | $(CC)
	@echo $$<
	$(quiet)$(MKDIR) -p $$(dir $$@)
	$(veryquiet)$(CC) -E -P -x c -C -Wundef -Werror $(C_DEFINES) $$< | sed -e 's/^[ \t]*//g' | sed -e 's/&apos;/\x27/g' > $$@
endef

define GZIP_template
$(1)_EMBEDDED_FILES = $(subst $(2),$(2).gz,$($(1)_EMBEDDED_FILES))
$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/files/$(call PRUNE_TO_MODULE_DIRECTORY,$(2)).gz: $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/files/$(call PRUNE_TO_MODULE_DIRECTORY,$(2))
	$(quiet)gzip -c $$< > $$<.gz
endef

define BUILD_FILE_STRUCT_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/c/$(call PRUNE_TO_MODULE_DIRECTORY,$(2)).c: \
  $(WORK_DIRECTORY)/$(PROJECT_NAME)/modules/$(1)/embedded/files/$(call PRUNE_TO_MODULE_DIRECTORY,$(2))
	@echo $$<
	$(veryquiet)$(MKDIR) -p $$(dir $$@)
	$(veryquiet)echo "/* Generated by makefile */" > $$@
	$(veryquiet)echo "#include \"ltrx_embedded_files.h\"" >> $$@
	$(veryquiet)echo "const struct ltrx_embedded_file Embedded_file_$(subst /,_slash_,$(subst .,_dot_,$(call PRUNE_TO_MODULE_DIRECTORY,$(2))))_contents = {" >> $$@
	$(veryquiet)echo "\"$(call PRUNE_TO_MODULE_DIRECTORY,$(2))\"", >> $$@
	$(veryquiet)echo "`stat -c%s $$<`," >>$$@
	$(veryquiet)od -An -bv $$< | sed -e 's/^/"/g' -e 's/$$$$/"/g' -e 's/ /\\/g' >> $$@
	$(veryquiet)echo -e "\"\"\n};" >> $$@
endef

define C_DEPENDENCY_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/dependencies/$(call MANGLE,$(1:.c=.dep)) : \
  $(1) $(ALL_GENERATED_HEADERS) | $(CC)
	@echo $$(notdir $$@)
	$(veryquiet)$(RM) $$@ $$@.$$$$
	$(veryquiet)$(CC) -MM -MF '$$@.$$$$' -MQ '$$@' $(call DEPENDENCY_INCLUDES,$(1)) $(addprefix -D,$(strip $(FEATURE_FLAGS) $(EVALUATED_FLAGS) $(VARDEF_NUMBER_RANGE_FLAGS))) $$<
	$(veryquiet)sed -e "s,\([a-zA-Z]\)\\:\/,\/\1\/,g" -e "s,$*[_a-z/A-Z.0-9-]*\.dep[ :]*,$(WORK_DIRECTORY)/$(PROJECT_NAME)/objects/$(call MANGLE,$(1:.c=.o)) $$@ : ," < $$@.$$$$ > $$@
	$(veryquiet)$(RM) $$@.$$$$
-include $(WORK_DIRECTORY)/$(PROJECT_NAME)/dependencies/$(call MANGLE,$(1:.c=.dep))
endef

define C_SOURCE_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/objects/$(call MANGLE,$(1:.c=.o)) : \
  $(1) $(ALL_GENERATED_HEADERS) | $(CC)
	@echo $$(notdir $$@)
	$(veryquiet)$(CC) $$(CFLAGS) $$(WARNFLAGS) $(call DEPENDENCY_INCLUDES,$(1)) $(C_DEFINES) -c $$< -o $$@
endef

define C_SOURCE_check_template
$(1) :
endef

define ASM_SOURCE_template
$(WORK_DIRECTORY)/$(PROJECT_NAME)/objects/$(call MANGLE,$(1:.s=.o)) : \
  $(1)
	@echo $$(notdir $$@)
	$(veryquiet)$(AS) $$(ASMFLAGS) -c $$< -o $$@
endef
