/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the “License Agreement”).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi product.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/****************************************************************************/
/*                                 Includes                                 */
/****************************************************************************/

#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bts_utils.h"
#include "uuid.h"


/****************************************************************************/
/*                           Function Definitions                           */
/****************************************************************************/

void bt_uuid_parse(const char *s, struct ltrx_uuid *lu)
{
    memset(lu, 0, sizeof(*lu));
    if (strlen(s) >= UUID_STRING_LENGTH)
    {
        uuid_t u;
        uuid_parse(s, u);
        lu->length = UUID_LENGTH_128;
        _reverse_byte_array(u, sizeof(u));
        memcpy(lu->uu.id128, u, UUID_LENGTH_128);
    }
    else
    {
        lu->uu.id32 = strtoul(s, NULL, 0);
        lu->length = (lu->uu.id32 > 0xFFFF) ? UUID_LENGTH_32 : UUID_LENGTH_16;
    }
}

char *bt_uuid_unparse(struct ltrx_uuid *lu, char *buffer, size_t length)
{
    static char default_buffer[40];
    if (buffer == NULL)
    {
        buffer = default_buffer;
        length = sizeof(default_buffer);
    }
    if (lu->length == UUID_LENGTH_16)
    {
        snprintf(buffer, length, "0x%04X", lu->uu.id16);
    }
    else if (lu->length == UUID_LENGTH_32)
    {
        snprintf(buffer, length, "0x%08" PRIx32 "", lu->uu.id32);
    }
    else
    {
        uuid_t u;
        memcpy(u, lu->uu.id128, sizeof(u));
        _reverse_byte_array(u, sizeof(u));
        uuid_unparse(u, buffer);
    }
    return buffer;
}
