
/*
 * Copyright 2017-2025, Lantronix, Inc. All Rights Reserved.
 *
 * This is UNPUBLISHED PROPRIETARY SOURCE CODE of Lantronix, Inc.;
 * the contents of this file may not be disclosed to third parties, copied
 * or duplicated in any form, in whole or in part, without the prior
 * written permission of Lantronix, Inc.
 */

#pragma once


/****************************************************************************/
/*                                 Defines                                  */
/****************************************************************************/

#define UUID__TEST_SERVICE \
    0x0b, 0x4f, 0xd5, 0x9a, 0xb7, 0x4f, 0x30, 0x90, \
    0x78, 0x40, 0xf9, 0x57, 0xfb, 0x39, 0xe3, 0x1f

#define UUID__TEST_CHARACTERISTIC_READ_WRITE \
    0x0c, 0x4f, 0xd5, 0x9a, 0xb7, 0x4f, 0x30, 0x90, \
    0x78, 0x40, 0xf9, 0x57, 0xfb, 0x39, 0xe3, 0x1f

#define UUID__TEST_CHARACTERISTIC_READ_WRITE_NR \
    0x0d, 0x4f, 0xd5, 0x9a, 0xb7, 0x4f, 0x30, 0x90, \
    0x78, 0x40, 0xf9, 0x57, 0xfb, 0x39, 0xe3, 0x1f

#define UUID__TEST_CHARACTERISTIC_STATUS \
    0x0e, 0x4f, 0xd5, 0x9a, 0xb7, 0x4f, 0x30, 0x90, \
    0x78, 0x40, 0xf9, 0x57, 0xfb, 0x39, 0xe3, 0x1f

#define BTS_MODE__WRITEBACK     0

#define BTS_MODE__DATALOGGING   1


/****************************************************************************/
/*                              Data Structures                             */
/****************************************************************************/

struct bts_stats
{
    uint16_t bs_connection_id;
    uint16_t bs_mtu;
    uint32_t bs_nwritten;
    uint16_t bs_queued_writes;
    uint16_t bs_queued_write_bytes;
    uint32_t bs_nread;
};

struct bts_status
{
    uint32_t time;
    struct bts_stats stats;
};

enum gatt_operation
{
    GATT_OPERATION__NONE,
    GATT_OPERATION__DISCOVERY,
    GATT_OPERATION__READ,
    GATT_OPERATION__WRITE,
    GATT_OPERATION__WRITE_EXECUTE,
    GATT_OPERATION__CONFIGURATION,
    GATT_OPERATION__NOTIFICATION,
    GATT_OPERATION__INDICATION,
};


/****************************************************************************/
/*                           Function Prototypes                            */
/****************************************************************************/

bool bts_start(void);

bool bts_stop(void);

bool bts_is_running(void);

bool bts_is_client_connected(void);

void bts_mode_set(uint8_t);

uint8_t bts_mode_get(void);

void bts_get_stats(struct bts_stats *);

