/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the “License Agreement”).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi product.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/


/****************************************************************************/
/*                                 Includes                                 */
/****************************************************************************/

#include <stdbool.h>
#include <stdint.h>

#include "ltrx_cfgvar.h"
#include "ltrx_gatt.h"


/****************************************************************************/
/*                                  Macros                                  */
/****************************************************************************/

#define NUM_GATT_CLIENT_CONNECTIONS     5

#define _reverse_byte_array(_a, _l) do { \
    for (uint32_t _i = 0, _j = (_l) - 1; _i < (_l) / 2; ++_i, --_j) \
    { \
        (_a)[_i] = (_a)[_i] ^ (_a)[_j]; \
        (_a)[_j] = (_a)[_i] ^ (_a)[_j]; \
        (_a)[_i] = (_a)[_i] ^ (_a)[_j]; \
    } \
} while (0)

#define BD_ADDR_IS_VALID(_a) ( \
    (_a)[0] || (_a)[1] || (_a)[2] || (_a)[3] || (_a)[4] || (_a)[5] \
)

#define VERIFY_CLI_ENVIRONMENT_OR_ABORT(_l) do { \
    if ( \
        (_l)->env != CFGVAR_TESTSET_ENVIRONMENT__CLI || \
        (_l)->optCliThreadInfo == NULL \
    ) \
    { \
        TLOG( \
            TLOG_SEVERITY_LEVEL__ERROR, \
            "This action is supported only through CLI." \
        ); \
        return false; \
    } \
} while (0)


/****************************************************************************/
/*                             Data Structures                              */
/****************************************************************************/

struct buffer_arg_context
{
    char *buffer;
    uint16_t length;
    uint16_t last;
    uint16_t current;
    bool inquotes;
};


/****************************************************************************/
/*                             Globals                                      */
/****************************************************************************/

extern const struct ltrx_module_info *g_bluetoothModule;


/****************************************************************************/
/*                            Function Prototypes                           */
/****************************************************************************/

void stream_printf(
    struct output_stream *,
    const char *,
    ...
);

bool str_bdaddr(const char *, uint8_t []);

void bt_uuid_parse(const char *, struct ltrx_uuid *);

char *bt_uuid_unparse(struct ltrx_uuid *, char *, size_t);

bool buffer_arg_init(
    const char *, struct buffer_arg_context *, uint32_t *
);

void buffer_arg_term(
    struct buffer_arg_context *
);

char *buffer_arg_next(
    struct buffer_arg_context *
);

int buffer_arg_getopt(
    struct buffer_arg_context *, const char *, char **
);
