
/*****************************************************************************/
/*                              Legal                                        */
/*****************************************************************************/

/*
** Copyright ©2015-2025, Lantronix, Inc. All Rights Reserved.
** By using this software, you are agreeing to the terms of the Software
** Development Kit (SDK) License Agreement included in the distribution package
** for this software (the “License Agreement”).
** Under the License Agreement, this software may be used solely to create
** custom applications for use on the Lantronix xPico Wi-Fi, xPico 200 Series,
** and xPort® Edge products.
** THIS SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION IS PROVIDED "AS IS".
** LANTRONIX SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
** TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS
** FOR A PARTICULAR PURPOSE.
** LANTRONIX HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
** ENHANCEMENTS, OR MODIFICATIONS TO THIS SOFTWARE.
** IN NO EVENT SHALL LANTRONIX BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
** SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
** ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
** LANTRONIX HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
** \addtogroup example
** @{
*/

/*!
** \defgroup ble_explorer ble_explorer
** @{
**
** The \b ble_explorer module provides utilities to inspect and communicate
** with BLE devices. This module operates only on the CLI; it does not have
** a Web Manager interface, and has the look and feel of a *nix commmand-line
** program.
**
** ble_explorer can scan and display nearby devices as well as scan and
** display BLE advertisements.
**
** It also offers GATT client functionality for discovering GATT services, as
** well as connecting to BLE central devices (GATT servers) and reading and
** writing to attributes available via those devices.
**
** \b Note: It is recommended that you enabled background scanning when
** using this demo application.
**
** Build it from project "bleExplorer"
*/

/****************************************************************************/
/*                                 Includes                                 */
/****************************************************************************/

#include "ble_explorer_module_defs.h" /* Automatically generated by make. */
#include "ltrx_cfgvar.h"



const struct bluetooth_external_functions *g_bluetoothExternalFunctionEntry_pointer;

const struct ltrx_module_info *g_bluetoothModule;


/****************************************************************************/
/*                           Function Definitions                           */
/****************************************************************************/

void ble_explorer_module_registration(void)
{
    ltrx_module_register(&g_ble_explorerModuleInfo);
}

void ble_explorer_module_startup(void)
{
    g_bluetoothExternalFunctionEntry_pointer = ltrx_module_functions_lookup(
        "bluetooth"
    );
    g_bluetoothModule = ltrx_module_lookup("bluetooth");
}

void ble_explorer_module_shutdown(void)
{
}

/*! @} End of Group. */
/*! @} End of Group. */
