/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.core.control.model.impl;

import org.eclipse.linuxtools.internal.lttng2.core.control.model.IBaseEventInfo;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceEventType;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.TraceLogLevel;
import org.eclipse.linuxtools.internal.lttng2.core.control.model.impl.TraceInfo;

public class BaseEventInfo
extends TraceInfo
implements IBaseEventInfo {
    private TraceEventType fEventType = TraceEventType.UNKNOWN;
    private TraceLogLevel fLogLevel = TraceLogLevel.TRACE_DEBUG;

    public BaseEventInfo(String name) {
        super(name);
    }

    public BaseEventInfo(BaseEventInfo other) {
        super(other);
        this.fEventType = other.fEventType;
    }

    @Override
    public TraceEventType getEventType() {
        return this.fEventType;
    }

    @Override
    public void setEventType(TraceEventType type) {
        this.fEventType = type;
    }

    @Override
    public void setEventType(String typeName) {
        this.fEventType = TraceEventType.TRACEPOINT.getInName().equals(typeName) ? TraceEventType.TRACEPOINT : (TraceEventType.SYSCALL.getInName().equals(typeName) ? TraceEventType.SYSCALL : (TraceEventType.PROBE.getInName().equals(typeName) ? TraceEventType.PROBE : TraceEventType.UNKNOWN));
    }

    @Override
    public TraceLogLevel getLogLevel() {
        return this.fLogLevel;
    }

    @Override
    public void setLogLevel(TraceLogLevel level) {
        this.fLogLevel = level;
    }

    @Override
    public void setLogLevel(String levelName) {
        this.fLogLevel = TraceLogLevel.TRACE_EMERG.getInName().equals(levelName) ? TraceLogLevel.TRACE_EMERG : (TraceLogLevel.TRACE_ALERT.getInName().equals(levelName) ? TraceLogLevel.TRACE_ALERT : (TraceLogLevel.TRACE_CRIT.getInName().equals(levelName) ? TraceLogLevel.TRACE_CRIT : (TraceLogLevel.TRACE_ERR.getInName().equals(levelName) ? TraceLogLevel.TRACE_ERR : (TraceLogLevel.TRACE_WARNING.getInName().equals(levelName) ? TraceLogLevel.TRACE_WARNING : (TraceLogLevel.TRACE_NOTICE.getInName().equals(levelName) ? TraceLogLevel.TRACE_NOTICE : (TraceLogLevel.TRACE_INFO.getInName().equals(levelName) ? TraceLogLevel.TRACE_INFO : (TraceLogLevel.TRACE_DEBUG_SYSTEM.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_SYSTEM : (TraceLogLevel.TRACE_DEBUG_PROGRAM.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_PROGRAM : (TraceLogLevel.TRACE_DEBUG_PROCESS.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_PROCESS : (TraceLogLevel.TRACE_DEBUG_MODULE.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_MODULE : (TraceLogLevel.TRACE_DEBUG_UNIT.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_UNIT : (TraceLogLevel.TRACE_DEBUG_FUNCTION.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_FUNCTION : (TraceLogLevel.TRACE_DEBUG_LINE.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG_LINE : (TraceLogLevel.TRACE_DEBUG.getInName().equals(levelName) ? TraceLogLevel.TRACE_DEBUG : (TraceLogLevel.LEVEL_UNKNOWN.getInName().equals(levelName) ? TraceLogLevel.LEVEL_UNKNOWN : TraceLogLevel.TRACE_DEBUG)))))))))))))));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fEventType == null ? 0 : this.fEventType.ordinal() + 1);
        result = 31 * result + (this.fLogLevel == null ? 0 : this.fLogLevel.ordinal() + 1);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseEventInfo other = (BaseEventInfo)obj;
        if (this.fEventType != other.fEventType) {
            return false;
        }
        return this.fLogLevel == other.fLogLevel;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[BaseEventInfo(");
        output.append(super.toString());
        output.append(",type=");
        output.append((Object)this.fEventType);
        output.append(",level=");
        output.append((Object)this.fLogLevel);
        output.append(")]");
        return output.toString();
    }
}

