/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view.annotatedsource;

import java.net.URI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.binutils.link2source.STLink2SourceSupport;
import org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.AbstractSTAnnotatedSourceEditorInput;
import org.eclipse.linuxtools.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.STAnnotatedSourceEditorInput;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.STAnnotatedSourceNotFoundEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenSourceFileAction {
    public static final OpenSourceFileAction sharedInstance = new OpenSourceFileAction();

    private OpenSourceFileAction() {
    }

    private IFileStore getFileStore(IProject project, IPath path) {
        IEditorInput input = STLink2SourceSupport.sharedInstance.getEditorInput(path, project);
        if (input instanceof IURIEditorInput) {
            IURIEditorInput editorInput = (IURIEditorInput)input;
            URI uri = editorInput.getURI();
            try {
                IFileStore fs = EFS.getStore((URI)uri);
                return fs;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    private AbstractSTAnnotatedSourceEditorInput getInput(SourceFile sourceFile, IFileStore fs) {
        STAnnotatedSourceEditorInput input = new STAnnotatedSourceEditorInput(fs, sourceFile);
        IWorkbenchPage p = CUIPlugin.getActivePage();
        IEditorPart editorPart = p.findEditor((IEditorInput)input);
        if (editorPart != null) {
            p.closeEditor(editorPart, false);
        }
        return input;
    }

    public void openAnnotatedSourceFile(IProject project, IFile binary, SourceFile sourceFile, int lineNumber) {
        if (sourceFile == null) {
            return;
        }
        String pathName = sourceFile.getName();
        if (pathName == null) {
            return;
        }
        Path path = new Path(pathName);
        this.openAnnotatedSourceFile(project, binary, sourceFile, (IPath)path, lineNumber);
    }

    public void openAnnotatedSourceFile(IProject project, IFile binary, SourceFile sourceFile, IPath realLocation, int lineNumber) {
        block10: {
            IWorkbenchPage page = CUIPlugin.getActivePage();
            if (page != null) {
                IFileStore fs = this.getFileStore(project, realLocation);
                if (fs == null && !realLocation.isAbsolute() && binary != null) {
                    IPath p = binary.getProjectRelativePath().removeLastSegments(1);
                    fs = this.getFileStore(project, p.append(realLocation));
                }
                if (fs == null) {
                    try {
                        page.openEditor((IEditorInput)new STAnnotatedSourceNotFoundEditorInput(project, sourceFile, realLocation, lineNumber), "org.eclipse.linuxtools.gcov.view.annotatedsource.STAnnotatedSourceNotFoundEditor", true);
                    }
                    catch (PartInitException e) {
                        Status s = new Status(4, "org.eclipse.linuxtools.gcov.core", 4, "Error when opening annotated source view", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)s);
                    }
                } else {
                    AbstractSTAnnotatedSourceEditorInput input = this.getInput(sourceFile, fs);
                    try {
                        IEditorPart editor = page.openEditor((IEditorInput)input, "org.eclipse.linuxtools.dataviewers.annotatedsourceeditor.editor", true);
                        if (lineNumber <= 0 || !(editor instanceof ITextEditor)) break block10;
                        IDocumentProvider provider = ((ITextEditor)editor).getDocumentProvider();
                        IDocument document = provider.getDocument((Object)editor.getEditorInput());
                        try {
                            int start = document.getLineOffset(lineNumber - 1);
                            ((ITextEditor)editor).selectAndReveal(start, 0);
                        }
                        catch (BadLocationException badLocationException) {}
                        IWorkbenchPage p = editor.getSite().getPage();
                        p.activate((IWorkbenchPart)editor);
                    }
                    catch (PartInitException e) {
                        Status s = new Status(4, "org.eclipse.linuxtools.gcov.core", 4, "Error when opening annotated source view", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)s);
                    }
                }
            }
        }
    }
}

