/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.sharing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.project.RepositoryFinder;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.repository.NewRepositoryWizard;
import org.eclipse.egit.ui.internal.sharing.MoveProjectsLabelProvider;
import org.eclipse.egit.ui.internal.sharing.RepoComboContentProvider;
import org.eclipse.egit.ui.internal.sharing.RepoComboLabelProvider;
import org.eclipse.egit.ui.internal.sharing.SharingWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExistingOrNewPage
extends WizardPage {
    private final SharingWizard myWizard;
    private Button button;
    private Tree tree;
    private CheckboxTreeViewer viewer;
    private Text repositoryToCreate;
    private IPath minumumPath;
    private Label dotGitSegment;
    private Composite externalComposite;
    private Composite parentRepoComposite;
    private Text workDir;
    private Text relPath;
    private Button browseRepository;
    private Repository selectedRepository;
    private CheckboxTableViewer projectMoveViewer;
    private final MoveProjectsLabelProvider moveProjectsLabelProvider = new MoveProjectsLabelProvider();
    private boolean internalMode = false;

    ExistingOrNewPage(SharingWizard w) {
        super(ExistingOrNewPage.class.getName());
        this.setTitle(UIText.ExistingOrNewPage_title);
        this.setImageDescriptor(UIIcons.WIZBAN_CONNECT_REPO);
        this.myWizard = w;
    }

    public void createControl(Composite parent) {
        final RepositoryUtil util = Activator.getDefault().getRepositoryUtil();
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(main);
        final Button internalModeButton = new Button(main, 32);
        internalModeButton.setText(UIText.ExistingOrNewPage_InternalModeCheckbox);
        internalModeButton.setToolTipText(UIText.ExistingOrNewPage_CreationInWorkspaceWarningTooltip);
        internalModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExistingOrNewPage.this.internalMode = internalModeButton.getSelection();
                ExistingOrNewPage.this.updateControls();
            }
        });
        this.externalComposite = new Composite(main, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.externalComposite);
        this.externalComposite.setLayout((Layout)new GridLayout(3, false));
        new Label(this.externalComposite, 0).setText(UIText.ExistingOrNewPage_ExistingRepositoryLabel);
        Combo existingRepoCombo = new Combo(this.externalComposite, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)existingRepoCombo);
        final ComboViewer v = new ComboViewer(existingRepoCombo);
        v.setContentProvider((IContentProvider)new RepoComboContentProvider());
        v.setLabelProvider((IBaseLabelProvider)new RepoComboLabelProvider());
        v.setInput(new Object());
        v.setSorter(new ViewerSorter());
        existingRepoCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExistingOrNewPage.this.selectedRepository = null;
                IStructuredSelection sel = (IStructuredSelection)v.getSelection();
                ExistingOrNewPage.this.setRepository((Repository)sel.getFirstElement());
                ExistingOrNewPage.this.updateControls();
            }
        });
        Button newRepo = new Button(this.externalComposite, 8);
        newRepo.setText(UIText.ExistingOrNewPage_CreateRepositoryButton);
        newRepo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRepositoryWizard wiz = new NewRepositoryWizard(true);
                if (new WizardDialog(ExistingOrNewPage.this.getShell(), (IWizard)wiz).open() == 0) {
                    v.refresh();
                    ExistingOrNewPage.this.selectedRepository = wiz.getCreatedRepository();
                    v.setSelection((ISelection)new StructuredSelection((Object)ExistingOrNewPage.this.selectedRepository));
                    ExistingOrNewPage.this.updateControls();
                }
            }
        });
        new Label(this.externalComposite, 0).setText(UIText.ExistingOrNewPage_WorkingDirectoryLabel);
        this.workDir = new Text(this.externalComposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.workDir);
        GridDataFactory.fillDefaults().applyTo((Control)this.workDir);
        new Label(this.externalComposite, 0);
        new Label(this.externalComposite, 0).setText(UIText.ExistingOrNewPage_RelativePathLabel);
        this.relPath = new Text(this.externalComposite, 2048);
        this.relPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExistingOrNewPage.this.updateControls();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.relPath);
        this.browseRepository = new Button(this.externalComposite, 8);
        this.browseRepository.setEnabled(false);
        this.browseRepository.setText(UIText.ExistingOrNewPage_BrowseRepositoryButton);
        this.browseRepository.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(ExistingOrNewPage.this.getShell());
                dlg.setFilterPath(ExistingOrNewPage.this.selectedRepository.getWorkTree().getPath());
                String directory = dlg.open();
                if (directory != null) {
                    ExistingOrNewPage.this.setRelativePath(directory);
                    ExistingOrNewPage.this.updateControls();
                }
            }
        });
        Table projectMoveTable = new Table(this.externalComposite, 67618);
        this.projectMoveViewer = new CheckboxTableViewer(projectMoveTable);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)projectMoveTable);
        TableColumn tc = new TableColumn(projectMoveTable, 0);
        tc.setText(UIText.ExistingOrNewPage_ProjectNameColumnHeader);
        tc.setWidth(100);
        tc = new TableColumn(projectMoveTable, 0);
        tc.setText(UIText.ExistingOrNewPage_CurrentLocationColumnHeader);
        tc.setWidth(250);
        tc = new TableColumn(projectMoveTable, 0);
        tc.setText(UIText.ExistingOrNewPage_NewLocationTargetHeader);
        tc.setWidth(350);
        projectMoveTable.setHeaderVisible(true);
        this.projectMoveViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.projectMoveViewer.setLabelProvider((IBaseLabelProvider)this.moveProjectsLabelProvider);
        this.projectMoveViewer.setInput((Object)this.myWizard.projects);
        this.projectMoveViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExistingOrNewPage.this.updateControls();
            }
        });
        TableItem[] children = this.projectMoveViewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            IProject data = (IProject)item.getData();
            RepositoryFinder repositoryFinder = new RepositoryFinder(data);
            try {
                Collection find = repositoryFinder.find((IProgressMonitor)new NullProgressMonitor());
                if (find.size() != 1) {
                    item.setChecked(true);
                }
            }
            catch (CoreException e1) {
                item.setText(2, e1.getMessage());
            }
            ++i;
        }
        this.parentRepoComposite = new Composite(main, 0);
        this.parentRepoComposite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.parentRepoComposite);
        this.tree = new Tree(this.parentRepoComposite, 67618);
        this.viewer = new CheckboxTreeViewer(this.tree);
        this.tree.setHeaderVisible(true);
        this.tree.setLayout((Layout)new GridLayout());
        this.tree.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(3, 1).create());
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectAndRepo checkable = (ProjectAndRepo)event.getElement();
                    TreeItem[] treeItemArray = ExistingOrNewPage.this.tree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem ti = treeItemArray[n2];
                        if (ti.getItemCount() > 0 || ((ProjectAndRepo)ti.getData()).getRepo().equals("")) {
                            ti.setChecked(false);
                        }
                        TreeItem[] treeItemArray2 = ti.getItems();
                        int n3 = treeItemArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TreeItem subTi = treeItemArray2[n4];
                            IProject project = ((ProjectAndRepo)subTi.getData()).getProject();
                            if (checkable.getProject() != null && !subTi.getData().equals(checkable) && checkable.getProject().equals((Object)project)) {
                                subTi.setChecked(false);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
        });
        TreeColumn c1 = new TreeColumn(this.tree, 0);
        c1.setText(UIText.ExistingOrNewPage_HeaderProject);
        c1.setWidth(100);
        TreeColumn c2 = new TreeColumn(this.tree, 0);
        c2.setText(UIText.ExistingOrNewPage_HeaderLocation);
        c2.setWidth(400);
        TreeColumn c3 = new TreeColumn(this.tree, 0);
        c3.setText(UIText.ExistingOrNewPage_HeaderRepository);
        c3.setWidth(200);
        boolean allProjectsInExistingRepos = true;
        IProject[] iProjectArray = this.myWizard.projects;
        int n = this.myWizard.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryFinder repositoryFinder = new RepositoryFinder(project);
            try {
                TreeItem treeItem;
                RepositoryMapping m;
                Collection mappings = repositoryFinder.find((IProgressMonitor)new NullProgressMonitor());
                Iterator mi = mappings.iterator();
                RepositoryMapping repositoryMapping = m = mi.hasNext() ? (RepositoryMapping)mi.next() : null;
                if (m == null) {
                    treeItem = new TreeItem(this.tree, 0);
                    this.updateProjectTreeItem(treeItem, project);
                    treeItem.setText(1, project.getLocation().toOSString());
                    treeItem.setText(2, "");
                    treeItem.setData((Object)new ProjectAndRepo(project, ""));
                    allProjectsInExistingRepos = false;
                } else if (!mi.hasNext()) {
                    treeItem = new TreeItem(this.tree, 0);
                    this.updateProjectTreeItem(treeItem, project);
                    treeItem.setText(1, project.getLocation().toOSString());
                    this.fillTreeItemWithGitDirectory(m, treeItem, false);
                    treeItem.setData((Object)new ProjectAndRepo(project, treeItem.getText(2)));
                    treeItem.setChecked(true);
                } else {
                    treeItem = new TreeItem(this.tree, 0);
                    this.updateProjectTreeItem(treeItem, project);
                    treeItem.setText(1, project.getLocation().toOSString());
                    treeItem.setData((Object)new ProjectAndRepo(null, null));
                    TreeItem treeItem2 = new TreeItem(treeItem, 0);
                    this.updateProjectTreeItem(treeItem2, project);
                    this.fillTreeItemWithGitDirectory(m, treeItem2, true);
                    treeItem2.setData((Object)new ProjectAndRepo(project, treeItem2.getText(2)));
                    while (mi.hasNext()) {
                        m = (RepositoryMapping)mi.next();
                        treeItem2 = new TreeItem(treeItem, 0);
                        this.updateProjectTreeItem(treeItem2, project);
                        this.fillTreeItemWithGitDirectory(m, treeItem2, true);
                        treeItem2.setData((Object)new ProjectAndRepo(m.getContainer().getProject(), treeItem2.getText(2)));
                    }
                    treeItem.setExpanded(true);
                    allProjectsInExistingRepos = false;
                }
            }
            catch (CoreException e) {
                TreeItem treeItem2 = new TreeItem(this.tree, 3);
                treeItem2.setText(e.getMessage());
            }
            ++n2;
        }
        this.button = new Button(this.parentRepoComposite, 8);
        this.button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.button.setText(UIText.ExistingOrNewPage_CreateButton);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String msg;
                File gitDir = new File(ExistingOrNewPage.this.repositoryToCreate.getText(), ".git");
                try {
                    FileRepository repository = new FileRepository(gitDir);
                    repository.create();
                    for (IProject project : ExistingOrNewPage.this.getProjects(false).keySet()) {
                        if (gitDir.toString().contains("..")) continue;
                        project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                    }
                    util.addConfiguredRepository(gitDir);
                }
                catch (IOException e1) {
                    msg = NLS.bind((String)UIText.ExistingOrNewPage_ErrorFailedToCreateRepository, (Object)gitDir.toString());
                    Activator.handleError(msg, e1, true);
                }
                catch (CoreException e2) {
                    msg = NLS.bind((String)UIText.ExistingOrNewPage_ErrorFailedToRefreshRepository, (Object)gitDir);
                    Activator.handleError(msg, e2, true);
                }
                TreeItem[] treeItemArray = ExistingOrNewPage.this.tree.getSelection();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    ti.setText(2, gitDir.toString());
                    ((ProjectAndRepo)ti.getData()).repo = gitDir.toString();
                    ti.setChecked(true);
                    ++n2;
                }
                ExistingOrNewPage.this.updateControls();
            }
        });
        this.repositoryToCreate = new Text(this.parentRepoComposite, 2052);
        this.repositoryToCreate.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(1, 1).create());
        this.repositoryToCreate.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                if (ExistingOrNewPage.this.repositoryToCreate.getText().equals("")) {
                    ExistingOrNewPage.this.button.setEnabled(false);
                    return;
                }
                IPath fromOSString = Path.fromOSString((String)ExistingOrNewPage.this.repositoryToCreate.getText());
                ExistingOrNewPage.this.button.setEnabled(ExistingOrNewPage.this.minumumPath.matchingFirstSegments(fromOSString) == fromOSString.segmentCount());
            }
        });
        this.dotGitSegment = new Label(this.parentRepoComposite, 0);
        this.dotGitSegment.setEnabled(false);
        this.dotGitSegment.setText(String.valueOf(File.separatorChar) + ".git");
        this.dotGitSegment.setLayoutData((Object)GridDataFactory.fillDefaults().align(16384, 0x1000000).create());
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExistingOrNewPage.this.tree.select((TreeItem)e.item);
                ExistingOrNewPage.this.updateControls();
            }
        });
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
        if (allProjectsInExistingRepos) {
            this.internalMode = true;
            internalModeButton.setSelection(true);
            this.updateControls();
        }
    }

    private void updateProjectTreeItem(TreeItem item, IProject project) {
        item.setImage(0, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
        item.setText(0, project.getName());
    }

    protected void setRelativePath(String directory) {
        IPath folderPath = new Path(directory).setDevice(null);
        IPath workdirPath = new Path(this.selectedRepository.getWorkTree().getPath()).setDevice(null);
        if (!workdirPath.isPrefixOf(folderPath)) {
            MessageDialog.openError((Shell)this.getShell(), (String)UIText.ExistingOrNewPage_WrongPathErrorDialogTitle, (String)UIText.ExistingOrNewPage_WrongPathErrorDialogMessage);
            return;
        }
        this.relPath.setText(folderPath.removeFirstSegments(workdirPath.segmentCount()).toString());
    }

    protected void setRepository(Repository repository) {
        if (repository == this.selectedRepository) {
            return;
        }
        this.selectedRepository = repository;
        this.relPath.setText("");
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateControls();
        }
    }

    private void fillTreeItemWithGitDirectory(RepositoryMapping m, TreeItem treeItem, boolean isAlternative) {
        if (m.getGitDir() == null) {
            treeItem.setText(2, UIText.ExistingOrNewPage_SymbolicValueEmptyMapping);
        } else {
            IPath container = m.getContainerPath();
            if (!container.isEmpty()) {
                container = Path.fromOSString((String)".");
            }
            IPath relativePath = container.append(m.getGitDir());
            if (isAlternative) {
                IPath withoutLastSegment = relativePath.removeLastSegments(1);
                IPath path = withoutLastSegment.isEmpty() ? Path.fromPortableString((String)".") : withoutLastSegment;
                treeItem.setText(0, path.toString());
            }
            treeItem.setText(2, relativePath.toOSString());
            try {
                IProject project = m.getContainer().getProject();
                FileRepository repo = new FileRepository(m.getGitDirAbsolutePath().toFile());
                File workTree = repo.getWorkTree();
                IPath workTreePath = Path.fromOSString((String)workTree.getAbsolutePath());
                if (workTreePath.isPrefixOf(project.getLocation())) {
                    IPath makeRelativeTo = project.getLocation().makeRelativeTo(workTreePath);
                    String repoRelativePath = makeRelativeTo.append("/.project").toPortableString();
                    ObjectId headCommitId = repo.resolve("HEAD");
                    if (headCommitId != null) {
                        RevWalk revWalk = new RevWalk((Repository)repo);
                        RevCommit headCommit = revWalk.parseCommit((AnyObjectId)headCommitId);
                        RevTree headTree = headCommit.getTree();
                        TreeWalk projectInRepo = TreeWalk.forPath((Repository)repo, (String)repoRelativePath, (RevTree)headTree);
                        if (projectInRepo != null) {
                            treeItem.setChecked(true);
                        }
                        revWalk.dispose();
                    }
                }
                repo.close();
            }
            catch (IOException e1) {
                Activator.logError(UIText.ExistingOrNewPage_FailedToDetectRepositoryMessage, e1);
            }
        }
    }

    protected void updateControls() {
        this.setMessage(null);
        this.setErrorMessage(null);
        if (!this.internalMode) {
            this.setDescription(UIText.ExistingOrNewPage_DescriptionExternalMode);
            if (this.selectedRepository != null) {
                this.workDir.setText(this.selectedRepository.getWorkTree().getPath());
                String relativePath = this.relPath.getText();
                File testFile = new File(this.selectedRepository.getWorkTree(), relativePath);
                if (!testFile.exists()) {
                    this.setMessage(NLS.bind((String)UIText.ExistingOrNewPage_FolderWillBeCreatedMessage, (Object)relativePath), 2);
                }
                Path targetPath = new Path(this.selectedRepository.getWorkTree().getPath());
                targetPath = targetPath.append(this.relPath.getText());
                this.moveProjectsLabelProvider.targetFolder = targetPath;
                this.projectMoveViewer.refresh(true);
                this.browseRepository.setEnabled(true);
                Object[] objectArray = this.projectMoveViewer.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object checked = objectArray[n2];
                    IProject prj = (IProject)checked;
                    IPath projectMoveTarget = targetPath.append(prj.getName());
                    boolean mustMove = !prj.getLocation().equals((Object)projectMoveTarget);
                    File targetTest = new File(projectMoveTarget.toOSString());
                    if (mustMove && targetTest.exists()) {
                        this.setErrorMessage(NLS.bind((String)UIText.ExistingOrNewPage_ExistingTargetErrorMessage, (Object)prj.getName()));
                    } else {
                        File parent = targetTest.getParentFile();
                        while (parent != null) {
                            if (new File(parent, ".project").exists()) {
                                this.setErrorMessage(NLS.bind((String)UIText.ExistingOrNewPage_NestedProjectErrorMessage, (Object[])new String[]{prj.getName(), targetTest.getPath(), parent.getPath()}));
                                break;
                            }
                            parent = parent.getParentFile();
                        }
                        if (this.getErrorMessage() == null) {
                            ++n2;
                            continue;
                        }
                    }
                    break;
                }
            } else {
                this.workDir.setText(UIText.ExistingOrNewPage_NoRepositorySelectedMessage);
            }
            this.setPageComplete(this.getErrorMessage() == null && this.selectedRepository != null && this.projectMoveViewer.getCheckedElements().length > 0);
        } else {
            this.setDescription(UIText.ExistingOrNewPage_description);
            this.minumumPath = null;
            IPath p = null;
            TreeItem[] treeItemArray = this.tree.getSelection();
            int n = treeItemArray.length;
            int targetPath = 0;
            while (targetPath < n) {
                TreeItem ti = treeItemArray[targetPath];
                if (ti.getItemCount() <= 0) {
                    String path = ti.getText(2);
                    if (!path.equals("")) {
                        p = null;
                        break;
                    }
                    String gitDirParentCandidate = ti.getText(1);
                    IPath thisPath = Path.fromOSString((String)gitDirParentCandidate);
                    if (p == null) {
                        p = thisPath;
                    } else {
                        int n3 = p.matchingFirstSegments(thisPath);
                        p = p.removeLastSegments(p.segmentCount() - n3);
                    }
                }
                ++targetPath;
            }
            this.minumumPath = p;
            if (p != null) {
                this.repositoryToCreate.setText(p.toOSString());
            } else {
                this.repositoryToCreate.setText("");
            }
            this.button.setEnabled(p != null);
            this.repositoryToCreate.setEnabled(p != null);
            this.dotGitSegment.setEnabled(p != null);
            boolean pageComplete = this.viewer.getCheckedElements().length > 0;
            Object[] objectArray = this.viewer.getCheckedElements();
            int n4 = objectArray.length;
            n = 0;
            while (n < n4) {
                Object checkedElement = objectArray[n];
                String path = ((ProjectAndRepo)checkedElement).getRepo();
                if (((ProjectAndRepo)checkedElement).getRepo() != null && path.equals("")) {
                    pageComplete = false;
                }
                ++n;
            }
            this.setPageComplete(pageComplete);
            objectArray = this.myWizard.projects;
            n4 = this.myWizard.projects.length;
            n = 0;
            while (n < n4) {
                Object project = objectArray[n];
                if (this.button.isEnabled() && ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf(project.getLocation())) {
                    this.setMessage(UIText.ExistingOrNewPage_RepoCreationInWorkspaceCreationWarning, 2);
                    break;
                }
                ++n;
            }
        }
        this.externalComposite.setVisible(!this.internalMode);
        this.parentRepoComposite.setVisible(this.internalMode);
        GridData gd = (GridData)this.parentRepoComposite.getLayoutData();
        gd.exclude = !this.internalMode;
        gd = (GridData)this.externalComposite.getLayoutData();
        gd.exclude = this.internalMode;
        ((Composite)this.getControl()).layout(true);
    }

    public Map<IProject, File> getProjects(boolean checked) {
        ISelection selection;
        Object[] elements;
        if (!this.internalMode) {
            if (checked) {
                elements = this.projectMoveViewer.getCheckedElements();
            } else {
                selection = this.viewer.getSelection();
                elements = ((IStructuredSelection)selection).toArray();
            }
        } else {
            elements = checked ? this.viewer.getCheckedElements() : ((selection = this.viewer.getSelection()) instanceof IStructuredSelection ? ((IStructuredSelection)selection).toArray() : new Object[]{});
        }
        HashMap<IProject, File> ret = new HashMap<IProject, File>(elements.length);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object ti = objectArray[n2];
            if (!this.internalMode) {
                File workdir = this.selectedRepository.getWorkTree();
                IProject project = (IProject)ti;
                IPath targetLocation = new Path(this.relPath.getText()).append(project.getName());
                File targetFile = new File(workdir, targetLocation.toOSString());
                ret.put(project, targetFile);
            } else {
                IPath selectedRepo;
                IProject project = ((ProjectAndRepo)ti).getProject();
                String path = ((ProjectAndRepo)ti).getRepo();
                IPath localPathToRepo = selectedRepo = Path.fromOSString((String)path);
                if (!selectedRepo.isAbsolute()) {
                    localPathToRepo = project.getLocation().append(selectedRepo);
                }
                ret.put(project, localPathToRepo.toFile());
            }
            ++n2;
        }
        return ret;
    }

    public boolean getInternalMode() {
        return this.internalMode;
    }

    public Repository getSelectedRepsoitory() {
        return this.selectedRepository;
    }

    private static class ProjectAndRepo {
        private IProject project;
        private String repo;

        public ProjectAndRepo(IProject project, String repo) {
            this.project = project;
            this.repo = repo;
        }

        public IProject getProject() {
            return this.project;
        }

        public String getRepo() {
            return this.repo;
        }
    }
}

