/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class PushToGerritPage
extends WizardPage {
    private static final String PUSH_TO_GERRIT_PAGE_SECTION = "PushToGerritPage";
    private static final String LAST_URI_POSTFIX = ".lastUri";
    private static final String LAST_BRANCH_POSTFIX = ".lastBranch";
    private final Repository repository;
    private final IDialogSettings settings;
    private final String lastUriKey;
    private final String lastBranchKey;
    private Combo uriCombo;
    private Label branchTextlabel;
    private Text branchText;

    PushToGerritPage(Repository repository) {
        super(PushToGerritPage.class.getName());
        this.repository = repository;
        this.setTitle(NLS.bind((String)UIText.PushToGerritPage_Title, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(repository)));
        this.setMessage(UIText.PushToGerritPage_Message);
        this.settings = this.getDialogSettings();
        this.lastUriKey = repository + LAST_URI_POSTFIX;
        this.lastBranchKey = repository + LAST_BRANCH_POSTFIX;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings s = Activator.getDefault().getDialogSettings();
        IDialogSettings section = s.getSection(PUSH_TO_GERRIT_PAGE_SECTION);
        if (section == null) {
            section = s.addNewSection(PUSH_TO_GERRIT_PAGE_SECTION);
        }
        return section;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)main);
        new Label(main, 0).setText(UIText.PushToGerritPage_UriLabel);
        this.uriCombo = new Combo(main, 4);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.uriCombo);
        this.uriCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushToGerritPage.this.checkPage();
            }
        });
        this.branchTextlabel = new Label(main, 0);
        Text prefix = new Text(main, 0);
        prefix.setText("refs/for/");
        prefix.setEnabled(false);
        this.branchTextlabel.setText(UIText.PushToGerritPage_BranchLabel);
        this.branchText = new Text(main, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.branchText);
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PushToGerritPage.this.checkPage();
            }
        });
        this.branchTextlabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                PushToGerritPage.this.branchText.setFocus();
                PushToGerritPage.this.branchText.selectAll();
            }
        });
        this.addRefContentProposalToText(this.branchText);
        TreeSet<String> uris = new TreeSet<String>();
        try {
            for (RemoteConfig rc : RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig())) {
                if (rc.getURIs().size() > 0) {
                    uris.add(((URIish)rc.getURIs().get(0)).toPrivateString());
                }
                for (URIish u : rc.getPushURIs()) {
                    uris.add(u.toPrivateString());
                }
            }
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, false);
            this.setErrorMessage(e.getMessage());
        }
        for (String aUri : uris) {
            this.uriCombo.add(aUri);
        }
        this.selectLastUsedUri();
        this.setLastUsedBranch();
        this.branchText.setFocus();
        Dialog.applyDialogFont((Control)main);
        this.setControl((Control)main);
    }

    private void storeLastUsedUri(String uri) {
        this.settings.put(this.lastUriKey, uri.trim());
    }

    private void storeLastUsedBranch(String branch) {
        this.settings.put(this.lastBranchKey, branch.trim());
    }

    private void selectLastUsedUri() {
        int i;
        String lastUri = this.settings.get(this.lastUriKey);
        if (lastUri != null && (i = this.uriCombo.indexOf(lastUri)) != -1) {
            this.uriCombo.select(i);
            return;
        }
        this.uriCombo.select(0);
    }

    private void setLastUsedBranch() {
        String lastBranch = this.settings.get(this.lastBranchKey);
        if (lastBranch != null) {
            this.branchText.setText(lastBranch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkPage() {
        block5: {
            block4: {
                this.setErrorMessage(null);
                try {
                    if (this.uriCombo.getText().length() == 0) {
                        this.setErrorMessage(UIText.PushToGerritPage_MissingUriMessage);
                        break block4;
                    }
                    if (this.branchText.getText().length() != 0) break block5;
                    this.setErrorMessage(UIText.PushToGerritPage_MissingBranchMessage);
                }
                catch (Throwable throwable) {
                    this.setPageComplete(this.getErrorMessage() == null);
                    throw throwable;
                }
            }
            this.setPageComplete(this.getErrorMessage() == null);
            return;
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    void doPush(IProgressMonitor monitor) {
        try {
            int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
            URIish uri = new URIish(this.uriCombo.getText());
            Ref currentHead = this.repository.getRef("HEAD");
            RemoteRefUpdate update = new RemoteRefUpdate(this.repository, currentHead, "refs/for/" + this.branchText.getText(), false, null, null);
            PushOperationSpecification spec = new PushOperationSpecification();
            spec.addURIRefUpdates(uri, Arrays.asList(update));
            PushOperationUI op = new PushOperationUI(this.repository, spec, timeout, false);
            op.setCredentialsProvider(new EGitCredentialsProvider());
            PushOperationResult result = op.execute(monitor);
            PushResultDialog dlg = new PushResultDialog(this.getShell(), this.repository, result, op.getDestinationString());
            dlg.showConfigureButton(false);
            dlg.open();
            this.storeLastUsedUri(this.uriCombo.getText());
            this.storeLastUsedBranch(this.branchText.getText());
        }
        catch (CoreException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    private void addRefContentProposalToText(Text textField) {
        KeyStroke stroke;
        try {
            stroke = KeyStroke.getInstance((String)"CTRL+SPACE");
            UIUtils.addBulbDecorator((Control)textField, NLS.bind((String)UIText.PushToGerritPage_ContentProposalHoverText, (Object)stroke.format()));
        }
        catch (ParseException e1) {
            Activator.handleError(e1.getMessage(), e1, false);
            stroke = null;
        }
        IContentProposalProvider cp = new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                Pattern pattern;
                ArrayList<BranchContentProposal> resultList = new ArrayList<BranchContentProposal>();
                String patternString = contents;
                while (patternString.length() > 0 && patternString.charAt(0) == ' ') {
                    patternString = patternString.substring(1);
                }
                patternString = Pattern.quote(patternString);
                if (!(patternString = patternString.replaceAll("\\x2A", ".*")).endsWith(".*")) {
                    patternString = String.valueOf(patternString) + ".*";
                }
                try {
                    pattern = Pattern.compile(patternString, 2);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    pattern = null;
                }
                TreeSet<String> proposals = new TreeSet<String>();
                try {
                    Set remotes = PushToGerritPage.this.repository.getRefDatabase().getRefs("refs/remotes/").keySet();
                    for (String remote : remotes) {
                        int slashIndex = remote.indexOf(47);
                        if (slashIndex <= 0 || slashIndex >= remote.length() - 1) continue;
                        proposals.add(remote.substring(remote.indexOf(47) + 1));
                    }
                }
                catch (IOException iOException) {}
                for (String proposal : proposals) {
                    if (pattern != null && !pattern.matcher(proposal).matches()) continue;
                    BranchContentProposal propsal = new BranchContentProposal(proposal);
                    resultList.add(propsal);
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        };
        ContentProposalAdapter adapter = new ContentProposalAdapter((Control)textField, (IControlContentAdapter)new TextContentAdapter(), cp, stroke, null);
        adapter.setProposalAcceptanceStyle(2);
    }

    private static final class BranchContentProposal
    implements IContentProposal {
        private final String myString;

        BranchContentProposal(String string) {
            this.myString = string;
        }

        public String getContent() {
            return this.myString;
        }

        public int getCursorPosition() {
            return 0;
        }

        public String getDescription() {
            return this.myString;
        }

        public String getLabel() {
            return this.myString;
        }

        public String toString() {
            return this.getContent();
        }
    }
}

