/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class MergeTargetSelectionDialog
extends AbstractBranchSelectionDialog {
    private boolean mergeSquash = false;

    public MergeTargetSelectionDialog(Shell parentShell, Repository repo) {
        super(parentShell, repo, MergeTargetSelectionDialog.getMergeTarget(repo), 0x4E | MergeTargetSelectionDialog.getSelectSetting(repo));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(UIText.MergeTargetSelectionDialog_ButtonMerge);
    }

    protected String getMessageText() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.MergeTargetSelectionDialog_SelectRefWithBranch, branch);
        }
        return UIText.MergeTargetSelectionDialog_SelectRef;
    }

    protected String getTitle() {
        String branch = this.getCurrentBranch();
        if (branch != null) {
            return MessageFormat.format(UIText.MergeTargetSelectionDialog_TitleMergeWithBranch, branch);
        }
        return UIText.MergeTargetSelectionDialog_TitleMerge;
    }

    protected void refNameSelected(String refName) {
        boolean currentSelected;
        boolean tagSelected = refName != null && refName.startsWith("refs/tags/");
        boolean branchSelected = refName != null && (refName.startsWith("refs/heads/") || refName.startsWith("refs/remotes/"));
        try {
            currentSelected = refName != null && refName.equals(this.repo.getFullBranch());
        }
        catch (IOException iOException) {
            currentSelected = false;
        }
        this.getButton(0).setEnabled(!currentSelected && (branchSelected || tagSelected));
    }

    protected void createCustomArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)main);
        Group g = new Group(main, 0);
        g.setText(UIText.MergeTargetSelectionDialog_MergeTypeGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)g);
        g.setLayout((Layout)new GridLayout(1, false));
        Button commit = new Button((Composite)g, 16);
        commit.setSelection(true);
        commit.setText(UIText.MergeTargetSelectionDialog_MergeTypeCommitButton);
        commit.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    MergeTargetSelectionDialog.this.mergeSquash = false;
                }
            }
        });
        Button squash = new Button((Composite)g, 16);
        squash.setText(UIText.MergeTargetSelectionDialog_MergeTypeSquashButton);
        squash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (((Button)event.widget).getSelection()) {
                    MergeTargetSelectionDialog.this.mergeSquash = true;
                }
            }
        });
    }

    public boolean isMergeSquash() {
        return this.mergeSquash;
    }
}

