/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtil {
    public static IResource getResourceForLocation(IPath location) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation(location);
        if (file != null) {
            return file;
        }
        return root.getContainerForLocation(location);
    }

    public static IFile getFileForLocation(Repository repository, String repoRelativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = new Path(repository.getWorkTree().getAbsolutePath()).append(repoRelativePath);
        return root.getFileForLocation(path);
    }

    public static Map<Repository, Collection<String>> splitResourcesByRepository(IResource[] resources) {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping(resource);
            if (repositoryMapping != null) {
                String path = repositoryMapping.getRepoRelativePath(resource);
                ResourceUtil.addPathToMap(repositoryMapping, path, result);
            }
            ++n2;
        }
        return result;
    }

    public static Map<Repository, Collection<String>> splitPathsByRepository(Collection<IPath> paths) {
        HashMap<Repository, Collection<String>> result = new HashMap<Repository, Collection<String>>();
        for (IPath path : paths) {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping(path);
            if (repositoryMapping == null) continue;
            String p = repositoryMapping.getRepoRelativePath(path);
            ResourceUtil.addPathToMap(repositoryMapping, p, result);
        }
        return result;
    }

    public static boolean isNonWorkspace(IResource resource) {
        return resource.getLocation() == null;
    }

    private static void addPathToMap(RepositoryMapping repositoryMapping, String path, Map<Repository, Collection<String>> result) {
        if (path != null && path.length() > 0) {
            Repository repository = repositoryMapping.getRepository();
            Collection<String> resourcesList = result.get(repository);
            if (resourcesList == null) {
                resourcesList = new ArrayList<String>();
                result.put(repository, resourcesList);
            }
            resourcesList.add(path);
        }
    }
}

