/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateNonTypeArgument;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPTemplateTypeArgument;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.core.runtime.CoreException;

public class PDOMCPPTemplateParameterMap {
    private static final int TYPE_OFFSET = 0;
    private static final int VALUE_OFFSET = 6;
    private static final int NODE_SIZE = 12;

    public static long putMap(PDOMNode parent, ICPPTemplateParameterMap map) throws CoreException {
        long block;
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        Integer[] keys = map.getAllParameterPositions();
        int keyLen = 0;
        int dataSize = 2;
        Integer[] integerArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Integer key = integerArray[n2];
            int delta = 18;
            ICPPTemplateArgument[] packExpansion = map.getPackExpansion(key);
            if (packExpansion != null) {
                delta += (packExpansion.length - 1) * 12;
            }
            if (dataSize + delta > 4094) break;
            dataSize += delta;
            ++keyLen;
            ++n2;
        }
        long p = block = db.malloc(dataSize);
        db.putShort(p, (short)keyLen);
        p += 2L;
        Integer[] integerArray2 = keys;
        int n3 = keys.length;
        int n4 = 0;
        while (n4 < n3) {
            Integer paramId = integerArray2[n4];
            if (--keyLen < 0) break;
            db.putInt(p, paramId);
            p += 4L;
            ICPPTemplateArgument arg = map.getArgument(paramId);
            if (arg != null) {
                db.putShort(p, (short)-1);
                PDOMCPPTemplateParameterMap.storeArgument(db, linkage, p += 2L, arg);
                p += 12L;
            } else {
                ICPPTemplateArgument[] args = map.getPackExpansion(paramId);
                db.putShort(p, (short)args.length);
                p += 2L;
                ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
                int n5 = args.length;
                int n6 = 0;
                while (n6 < n5) {
                    ICPPTemplateArgument a = iCPPTemplateArgumentArray[n6];
                    PDOMCPPTemplateParameterMap.storeArgument(db, linkage, p, a);
                    p += 12L;
                    ++n6;
                }
            }
            ++n4;
        }
        assert (p == block + (long)dataSize);
        return block;
    }

    private static void storeArgument(Database db, PDOMLinkage linkage, long p, ICPPTemplateArgument arg) throws CoreException {
        if (arg.isNonTypeValue()) {
            linkage.storeType(p + 0L, arg.getTypeOfNonTypeValue());
            linkage.storeValue(p + 6L, arg.getNonTypeValue());
        } else {
            linkage.storeType(p + 0L, arg.getTypeValue());
        }
    }

    public static void clearMap(PDOMNode parent, int record) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        long p = record;
        int len = db.getShort(p);
        p += 2L;
        int i = 0;
        while (i < len) {
            int packSize = db.getShort(p += 4L);
            p += 2L;
            if (packSize == -1) {
                packSize = 1;
            }
            int j = 0;
            while (j < packSize) {
                linkage.storeType(p + 0L, null);
                linkage.storeValue(p + 6L, null);
                p += 12L;
                ++j;
            }
            ++i;
        }
        db.free(record);
    }

    public static CPPTemplateParameterMap getMap(PDOMNode parent, long rec) throws CoreException {
        PDOMLinkage linkage = parent.getLinkage();
        Database db = linkage.getDB();
        int len = db.getShort(rec);
        if (len == 0) {
            return CPPTemplateParameterMap.EMPTY;
        }
        rec += 2L;
        CPPTemplateParameterMap result = new CPPTemplateParameterMap(len);
        int i = 0;
        while (i < len) {
            int parPos = db.getInt(rec);
            short packSize = db.getShort(rec += 4L);
            rec += 2L;
            if (packSize == -1) {
                ICPPTemplateArgument arg = PDOMCPPTemplateParameterMap.readArgument(rec, linkage, db);
                rec += 12L;
                result.put(parPos, arg);
            } else {
                ICPPTemplateArgument[] packExpansion = new ICPPTemplateArgument[packSize];
                int j = 0;
                while (j < packExpansion.length) {
                    packExpansion[j] = PDOMCPPTemplateParameterMap.readArgument(rec, linkage, db);
                    rec += 12L;
                    ++j;
                }
                result.put(parPos, packExpansion);
            }
            ++i;
        }
        return result;
    }

    private static ICPPTemplateArgument readArgument(long rec, PDOMLinkage linkage, Database db) throws CoreException {
        IValue val;
        IType type = linkage.loadType(rec + 0L);
        if (type == null) {
            type = new ProblemType(10005);
        }
        ICPPTemplateArgument arg = (val = linkage.loadValue(rec + 6L)) != null ? new CPPTemplateNonTypeArgument(val, type) : new CPPTemplateTypeArgument(type);
        return arg;
    }
}

