/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.astwriter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;

public class ContainerNode
extends ASTNode {
    private final IASTTranslationUnit tu = null;
    private final ArrayList<IASTNode> nodes = new ArrayList();

    public ContainerNode(IASTNode ... nodes) {
        IASTNode[] iASTNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode each = iASTNodeArray[n2];
            this.addNode(each);
            ++n2;
        }
    }

    @Override
    public ContainerNode copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public ContainerNode copy(IASTNode.CopyStyle style) {
        ContainerNode copy = new ContainerNode(new IASTNode[0]);
        for (IASTNode node : this.getNodes()) {
            copy.addNode(node == null ? null : node.copy(style));
        }
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    public void addNode(IASTNode node) {
        this.nodes.add(node);
        if (node.getParent() == null) {
            node.setParent(this.tu);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        boolean ret = true;
        for (IASTNode node : this.nodes) {
            ret = node.accept(visitor);
        }
        return ret;
    }

    public IASTTranslationUnit getTu() {
        return this.tu;
    }

    public List<IASTNode> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }
}

